package gov.va.med.pharmacy.peps.presentation.service.ndf.update;

import static gov.va.med.pharmacy.peps.common.utility.ESAPIValidationType.XML_EXT_ENTITY_INJ;
import static gov.va.med.pharmacy.peps.common.utility.ESAPIValidator.validateStringInput;
import gov.va.med.pharmacy.peps.common.exception.ValidationException;
import gov.va.med.pharmacy.peps.common.object.VistaUpdateStatus;
import gov.va.med.pharmacy.peps.service.common.session.VistaUpdateService;

import java.io.ByteArrayInputStream;
import java.io.InputStream;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.w3c.dom.Document;


/**
 * Controller for Vista Status Update interactions.
 * @uml.annotations 
 *    uml_dependency="mmi:///#jsrctype^name=VistaUpdateService[jcu^name=VistaUpdateService.java[jpack^name=gov.va.med.pharmacy.peps.service.common.session[jsrcroot^srcfolder=src/main/java[project^id=PS_PPS_srv]]]]$uml.Interface"
 */
@Controller
@RequestMapping("/update/status")
public class VistaUpdateStatusController {

    /** Logger. */
    private static final Logger LOG = LogManager.getLogger(VistaUpdateStatusController.class);
    
    /** The vista update service. */
    @Autowired
    private VistaUpdateService vistaUpdateService;

    
    /**
     * POST method for submitting a Vista Status Update.
     *
     * @param request the request
     * @param ndfUpdateStatus the ndf update status
     * @param response the response
     * @return the vista update status
     */
    @RequestMapping(method = RequestMethod.POST)
    @ResponseStatus(value = HttpStatus.OK)
    @ResponseBody
    public VistaUpdateStatus createMessage(HttpServletRequest request, @RequestParam(value = "xmlRequest") 
        String ndfUpdateStatus, HttpServletResponse response) {
    
        VistaUpdateStatus vistaUpdateStatus = new VistaUpdateStatus();
        try {
            LOG.debug("request received from " + request.getRemoteAddr());
            JAXBContext context = JAXBContext.newInstance(VistaUpdateStatus.class);
            Unmarshaller unmarshaller = context.createUnmarshaller();
            
            String validatedInput = validateStringInput(ndfUpdateStatus, XML_EXT_ENTITY_INJ);
            InputStream is = new ByteArrayInputStream(validatedInput.getBytes());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setExpandEntityReferences(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(is);
            vistaUpdateStatus = (VistaUpdateStatus)unmarshaller.unmarshal(document);
            
            vistaUpdateService.saveUpdate(vistaUpdateStatus.toVo());
            LOG.debug(vistaUpdateStatus.toString());
        } catch (ValidationException e) {
            LOG.info(e);
            vistaUpdateStatus.setMessage(e.getLocalizedMessage());
        } catch (Throwable t) {
            LOG.error("PPS-N Internal Error Occurred.", t);
            vistaUpdateStatus.setMessage("PPS-N Internal Error Occurred.");
        }
        return vistaUpdateStatus;
        
    }
    
    
    /**
     * GET.
     *
     * @param request the request
     * @param response the response
     * @return the message
     * @throws Exception the exception
     */
    @RequestMapping(method = RequestMethod.GET)
    @ResponseStatus(value = HttpStatus.CREATED)
    @ResponseBody
    public VistaUpdateStatus getMessage(HttpServletRequest request, HttpServletResponse response)
        throws Exception {
        LOG.debug("get request received from " + request.getRemoteAddr());        
        
        return new VistaUpdateStatus();
    }
    
    
    /**
     * Gets the vista update service.
     *
     * @return the vistaUpdateService
     */
    public final VistaUpdateService getVistaUpdateService() {
        return vistaUpdateService;
    }
    
    
    /**
     * Sets the vista update service.
     *
     * @param vistaUpdateService the vistaUpdateService to set
     */
    public final void setVistaUpdateService(VistaUpdateService vistaUpdateService) {
        this.vistaUpdateService = vistaUpdateService;
    }
}
