/**
 * 
 */
package gov.va.med.pharmacy.peps.presentation.common.utility.impl;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Logger;
import org.owasp.esapi.errors.ValidationException;

/**
 *
 */
public class PPSSecurityWrapperRequest extends org.owasp.esapi.filters.SecurityWrapperRequest{

    public PPSSecurityWrapperRequest(HttpServletRequest request) {
        super(request);
        // TODO Auto-generated constructor stub
    }
    /**
     * Returns the context path from the HttpServletRequest after canonicalizing
     * and filtering out any dangerous characters.
     * @return The context path for this {@code HttpServletRequest}
     */
    public String getContextPath() {
        String path = getHttpServletRequest().getContextPath();

        //Return empty String for the ROOT context
        if (path == null || "".equals(path.trim())) return "";

        String clean = "";
        try {
            clean = ESAPI.validator().getValidInput("HTTP context path: " + path, path, "HTTPContextPath", 
                    ESAPI.securityConfiguration().getMaxHttpHeaderSize(), false);
        } catch (ValidationException e) {
            // already logged
        }
        return clean;
    }

    /**
     * Returns the enumeration of header names from the HttpServletRequest after
     * canonicalizing and filtering out any dangerous characters.
     * @return An {@code Enumeration} of header names associated with this request.
     */
    public Enumeration getHeaderNames() {
        Vector<String> v = new Vector<String>();
        Enumeration en = getHttpServletRequest().getHeaderNames();
        while (en.hasMoreElements()) {
            try {
                String name = (String) en.nextElement();
                String clean = ESAPI.validator().getValidInput("HTTP header name: " + name, name, "HTTPHeaderName", 
                        ESAPI.securityConfiguration().getMaxHttpHeaderSize(), true);
                v.add(clean);
            } catch (ValidationException e) {
                // already logged
            }
        }
        return v.elements();
    }

    /**
     * Returns the enumeration of headers from the HttpServletRequest after
     * canonicalizing and filtering out any dangerous characters.
     * @param name The name of an HTTP request header.
     * @return An {@code Enumeration} of headers from the request after
     *         canonicalizing and filtering has been performed.
     */
    public Enumeration getHeaders(String name) {
        Vector<String> v = new Vector<String>();
        Enumeration en = getHttpServletRequest().getHeaders(name);
        while (en.hasMoreElements()) {
            try {
                String value = (String) en.nextElement();
                String clean = ESAPI.validator().getValidInput("HTTP header value (" + name + "): " + value, value, "HTTPHeaderValue", 
                        ESAPI.securityConfiguration().getMaxHttpHeaderSize(), true);
                v.add(clean);
            } catch (ValidationException e) {
                // already logged
            }
        }
        return v.elements();
    }
    
    /**
     * Returns the enumeration of parameter names from the HttpServletRequest
     * after canonicalizing and filtering out any dangerous characters.
     * @return An {@code Enumeration} of properly "scrubbed" parameter names.
     */
    public Enumeration getParameterNames() {
        Vector<String> v = new Vector<String>();
        Enumeration en = getHttpServletRequest().getParameterNames();
        while (en.hasMoreElements()) {
            try {
                String name = (String) en.nextElement();
                String clean = ESAPI.validator().getValidInput("HTTP parameter name: " + name, name, "HTTPParameterName", 
                        ESAPI.securityConfiguration().getMaxHttpHeaderSize(), true);
                v.add(clean);
            } catch (ValidationException e) {
                // already logged
            }
        }
        return v.elements();
    }
    
    /**
     * Returns the path info from the HttpServletRequest after canonicalizing
     * and filtering out any dangerous characters.
     * @return Returns any extra path information, appropriately scrubbed,
     *         associated with the URL the client sent when it made this request.
     */
    public String getPathInfo() {
        String path = getHttpServletRequest().getPathInfo();
        if (path == null) return null;
        String clean = "";
        try {
            clean = ESAPI.validator().getValidInput("HTTP path: " + path, path, "HTTPPath", 
                    ESAPI.securityConfiguration().getMaxHttpHeaderSize(), true);
        } catch (ValidationException e) {
            // already logged
        }
        return clean;
    }
    
    /* (non-Javadoc)
     * @see org.owasp.esapi.filters.SecurityWrapperRequest#getHeader(java.lang.String)
     */
    @Override
    /**
     * Returns the named header from the HttpServletRequest after canonicalizing
     * and filtering out any dangerous characters.
     * @param name The name of an HTTP request header
     * @return The specified header value is returned.
     */
    public String getHeader(String name) {
        String value = getHttpServletRequest().getHeader(name);
        String clean = "";
        try {
            clean = ESAPI.validator().getValidInput("HTTP header value: " + value, value, "HTTPHeaderValue", 
                    ESAPI.securityConfiguration().getMaxHttpHeaderSize(), true);
        } catch (ValidationException e) {
            // already logged
        }
        return clean;
    }    
    
    private HttpServletRequest getHttpServletRequest() {
        return (HttpServletRequest)super.getRequest();
    }    
}
