

package gov.va.med.pharmacy.peps.presentation.common.controller.migration;


import gov.va.med.pharmacy.peps.common.vo.Role;
import gov.va.med.pharmacy.peps.domain.common.utility.PackageSizeFileReader;
import gov.va.med.pharmacy.peps.presentation.common.spring.annotation.RoleNeeded;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;


@Controller
@RoleNeeded(roles = { Role.PSS_PPSN_MIGRATOR })
public class MigrationPackageSizeController {

    private static final String PAGE = "migration-packagesize-page";

    @Autowired
    private PackageSizeFileReader packageSizeFileReader;

    @RequestMapping(value = "/migrationPackageSize.go", method = RequestMethod.GET)
    public ModelAndView getPage() {
        return new ModelAndView(PAGE);
    }

    @RequestMapping(value = "/migrationPackageSize.go", method = RequestMethod.POST)
    public ModelAndView migratePackageSize(HttpServletRequest request, HttpServletResponse response,
        @RequestParam("file") MultipartFile file) {
        RandomAccessFile rFile = null;
        String error = null;
        
        try {
            File tmp = File.createTempFile("tmp", "txt");
            file.transferTo(tmp);
            rFile = new RandomAccessFile(tmp, "rw");
            getPackageSizeFileReader().setFile(rFile);
            getPackageSizeFileReader().processFile();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            error = "file failed";
        } finally {
            
            try {
                if (rFile != null){
                rFile.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
                error = "file failed to close";
            }     
        }
        ModelAndView view = new ModelAndView(PAGE);
        view.addObject("error", error);
        return view;
    }

    /**
     * @return the packageSizeFileReader
     */
    public PackageSizeFileReader getPackageSizeFileReader() {
        return packageSizeFileReader;
    }

    /**
     * @param packageSizeFileReader the packageSizeFileReader to set
     */
    public void setPackageSizeFileReader(PackageSizeFileReader packageSizeFileReader) {
        this.packageSizeFileReader = packageSizeFileReader;
    }

 }
