

package gov.va.med.pharmacy.peps.presentation.common.controller.migration;


import gov.va.med.pharmacy.peps.common.vo.Role;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.capability.ProductDomainCapability;
import gov.va.med.pharmacy.peps.domain.common.utility.DDIFileReader;
import gov.va.med.pharmacy.peps.presentation.common.spring.annotation.RoleNeeded;
import gov.va.med.pharmacy.peps.presentation.common.spring.interceptor.PepsSpringInterceptor;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;


@Controller
@RoleNeeded(roles = { Role.PSS_PPSN_MIGRATOR })
public class MigrationDdiControler {

    private static final String PAGE = "migration-ddi-page";

    @Autowired
    private DDIFileReader ddFileReader;
    @Autowired
    private ProductDomainCapability productDomainCapability;

    @RequestMapping(value = "/migrationDDI.go", method = RequestMethod.GET)
    public ModelAndView getPage() {
        return new ModelAndView(PAGE);
    }

    @RequestMapping(value = "/migrationDDI.go", method = RequestMethod.POST)
    public ModelAndView migrateDDI(HttpServletRequest request, HttpServletResponse response,
        @RequestParam("file") MultipartFile file) {
        RandomAccessFile rFile = null;
        String error = null;
        
        try {
            File tmp = File.createTempFile("tmp", "txt");
            file.transferTo(tmp);
            rFile = new RandomAccessFile(tmp, "rw");
            getDdFileReader().setFile(rFile);
            getDdFileReader().processFile();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
            error = "file failed";
        } finally {
            
            try {
                if (rFile != null){
                rFile.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
                error = "file failed to close";
            }     
        }
        ModelAndView view = new ModelAndView(PAGE);
        view.addObject("error", error);
        return view;
    }

    /**
     * @return the ddFileReader
     */
    public DDIFileReader getDdFileReader() {
        return ddFileReader;
    }

    /**
     * @param ddFileReader the ddFileReader to set
     */
    public void setDdFileReader(DDIFileReader ddFileReader) {
        this.ddFileReader = ddFileReader;
    }

    /**
     * @return the productDomainCapability
     */
    public ProductDomainCapability getProductDomainCapability() {
        return productDomainCapability;
    }

    /**
     * @param productDomainCapability the productDomainCapability to set
     */
    public void setProductDomainCapability(ProductDomainCapability productDomainCapability) {
        this.productDomainCapability = productDomainCapability;
    }

}
