package gov.va.med.pharmacy.peps.service.common.utility;

import static org.junit.Assert.*;
import static org.hamcrest.CoreMatchers.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

import org.junit.Test;
/*
 * testing the static methods of the test subject here..
 */
public class NdfUpdateMesssageUtilityTest {

    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String ARBITRARY_STRING = "could be anything";
    private static final String[] EXPECTED_STARTER_MESSAGE_PARTS = new String[] {
        "MESSAGE^0^0",
        "^^xxx^xxx^" + ARBITRARY_STRING
    };
    private static final String[] EXPECTED_STARTER_MESSAGE2_PARTS = new String[] {
        "MESSAGE2^0^0",
        "^^xxx^xxx^" + ARBITRARY_STRING
    };


    @Test
    public void should_create_starter_message() throws Exception {
        // arrange
        StringBuffer message = new StringBuffer();

        // act
        StringBuffer result = NdfUpdateMessageUtility.starterMESSAGE(message, ARBITRARY_STRING);

        // assert
        String expectedMsg = Arrays.stream(EXPECTED_STARTER_MESSAGE_PARTS).collect(Collectors.joining(NEWLINE));
        assertThat(result.toString(), equalTo(expectedMsg + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_create_starter_message2() throws Exception {
        // arrange
        StringBuffer message = new StringBuffer();

        // act
        StringBuffer result = NdfUpdateMessageUtility.starterMESSAGE2(message, ARBITRARY_STRING);

        // assert
        String expectedMsg = Arrays.stream(EXPECTED_STARTER_MESSAGE2_PARTS).collect(Collectors.joining(NEWLINE));
        assertThat(result.toString(), equalTo(expectedMsg + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_append_message_start() throws Exception {
        int count = 10;
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatHeaderRowForMESSAGEStart(count, message);
        assertThat(result.toString(), equalTo(NEWLINE + "MESSAGE^" + count + "^0" + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_append_message_end() throws Exception {
        int count = 55;
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatHeaderRowForMESSAGEEnd(count, message);
        assertThat(result.toString(), equalTo("MESSAGE^" + count + "^0" + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_append_message2_start() throws Exception {
        int count = 10;
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatHeaderRowForMESSAGE2Start(count, message);
        assertThat(result.toString(), equalTo(NEWLINE + "MESSAGE2^" + count + "^0" + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_append_message2_end() throws Exception {
        int count = 55;
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatHeaderRowForMESSAGE2End(count, message);
        assertThat(result.toString(), equalTo("MESSAGE2^" + count + "^0" + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_add_data_row() throws Exception {
        String data = "whacked-out data";
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatDataRowForMESSAGE(data, message);
        assertThat(result.toString(), equalTo(NdfUpdateMessageUtility.doubledSpace + data + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_add_inner_title() throws Exception {
        String data = "whacked-out data";
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatDataRowForInnerTitle(data, message);
        assertThat(result.toString(), equalTo(NdfUpdateMessageUtility.space + data + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_add_title_data() throws Exception {
        String data = "whacked-out data";
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatTitleDataRowForMESSAGE(data, message);
        assertThat(result.toString(), equalTo(data + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_add_new_data() throws Exception {
        String data = "whacked-out data";
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatNewDataRowForMESSAGE(data, message);
        assertThat(result.toString(), equalTo(NDFUpdateFileMapping.NEW + data + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_add_old_data() throws Exception {
        String data = "whacked-out data";
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatOldDataRowForMESSAGE(data, message);
        assertThat(result.toString(), equalTo(NDFUpdateFileMapping.OLD + data + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_add_line() throws Exception {
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatAddLine(message);
        assertThat(result.toString(), equalTo(NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_add_data() throws Exception {
        String data = "whacked-out data";
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatAddData(data, message);
        assertThat(result.toString(), equalTo(NdfUpdateMessageUtility.doubledSpace + data));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_add_header_line() throws Exception {
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatAddHeaderLine(message);
        assertThat(result.toString(), equalTo(NDFUpdateFileMapping.BORDER + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_add_data_end() throws Exception {
        int count = 10;
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatDataEndMESSAGE(count, message);
        assertThat(result.toString(), equalTo("MESSAGE^" + count + "^0" + NEWLINE + " " + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_add_parallel_data_sqr() throws Exception {
        String data1 = "whacked-out";
        String data2 = "data";
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatParallelDataSqr(data1, data2, message);
        assertThat(result.toString(), equalTo(NdfUpdateMessageUtility.doubledSpace + data1 + NdfUpdateMessageUtility.spacer + "[" + data2 + "]" + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_add_parallel_data_none() throws Exception {
        String data1 = "whacked-out";
        String data2 = "data";
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatParallelDataNone(data1, data2, message);
        assertThat(result.toString(), equalTo(NdfUpdateMessageUtility.doubledSpace + data1 + NdfUpdateMessageUtility.spacer + data2 + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    /*
     * same test as above, effectively..
     */
    @Test
    public void should_add_parallel_data() throws Exception {
        String data1 = "whacked-out";
        String data2 = "data";
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatParallelData(data1, data2, message);
        assertThat(result.toString(), equalTo(NdfUpdateMessageUtility.doubledSpace + data1 + NdfUpdateMessageUtility.spacer2 + data2 + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_add_parallel_data_no_line() throws Exception {
        String data1 = "whacked-out";
        String data2 = "data";
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatParallelDataNoLine(data1, data2, message);
        assertThat(result.toString(), equalTo(NdfUpdateMessageUtility.doubledSpace + data1 + NdfUpdateMessageUtility.spacer2 + data2));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    }

    @Test
    public void should_add_parallel_data_space() throws Exception {
        String data1 = "whacked-out";
        String data2 = "data";
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatParallelDataSpace(data1, data2, message);
        assertThat(result.toString(), equalTo(NdfUpdateMessageUtility.doubledSpace + data1 + NdfUpdateMessageUtility.spacer3 + data2 + NEWLINE));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    } 

    @Test
    public void should_add_space() throws Exception {
        String data1 = "whacked-out data";
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatSpaceData(data1, message);
        assertThat(result.toString(), equalTo(NdfUpdateMessageUtility.spacer + data1));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    } 

    @Test
    public void should_add_newline() throws Exception {
        String data1 = "whacked-out data";
        StringBuffer message = new StringBuffer();
        StringBuffer result = NdfUpdateMessageUtility.formatNewLineData(data1, message);
        assertThat(result.toString(), equalTo(NEWLINE + data1));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    } 

    @Test
    public void should_replace_total_placeholder() throws Exception {
        int count = 55;
        StringBuffer message = new StringBuffer("blah blah xxx^xxx blah");
        StringBuffer result = NdfUpdateMessageUtility.totalLineUpdate(count, message);
        assertThat(result.toString(), equalTo("blah blah 55^55 blah"));
        // NB: ideally, message should not be changed and the references result and message should be non-equal..
        //assertThat(result, not(sameInstance(message)));
    } 

    @Test(expected=StringIndexOutOfBoundsException.class)
    public void should_be_interesting_when_placeholder_missing() throws Exception {
        StringBuffer message = new StringBuffer("blah blah xxxxxxx blah");
        NdfUpdateMessageUtility.totalLineUpdate(12, message);
    } 
    
    @Test
    public void test_file_name_new_id_generation(){
        List<String> list = new ArrayList<String>();

        Pattern p = Pattern.compile("\\d+");
        Matcher m = p.matcher("PPS_126PRV_127NEW.DAT"); 
        while (m.find()) {
            list.add(m.group());
         }            
        assertEquals("127", list.get(1));
    }

}
