/**
 * Source file created in 2011 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.service.common.utility;


import static gov.va.med.pharmacy.peps.common.utility.IOUtility.safeClose;
import static gov.va.med.pharmacy.peps.common.utility.IOUtility.safeFlush;
import gov.va.med.pharmacy.peps.common.vo.ReportProductVo;
import gov.va.med.pharmacy.peps.common.vo.ReportType;
import gov.va.med.pharmacy.peps.service.common.session.ReportsService;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;


/**
 * ReportProposedInactivationCsvFile's brief summary
 * 
 * Details of ReportProposedInactivationCsvFile's operations, special dependencies
 * or protocols developers shall know about when using the class.
 *
 */
public class ReportProposedInactivationCsvFile extends CsvFile {

    private static final Logger LOG = LogManager.getLogger(ReportProposedInactivationCsvFile.class);
    private static final String PATH = "./tmp/";
    private static final String FILENAME = 
        ReportType.ACTIVE_PRODUCTS_PROPOSED_INACTIVATION_REPORT_PRINT_TEMPLATE.getView() + ".csv";
    private ReportsService reportsService;

    /**
     * Constructor
     *
     */
    public ReportProposedInactivationCsvFile() {
        super();
    }

    /**
     * Constructor
     *
     * @param reportsService ReportsService
     */
    public ReportProposedInactivationCsvFile(ReportsService reportsService) {
        super();

        this.reportsService = reportsService;
    }

    /**
     * createFile
     *
     * @param startDate Date
     * @param stopDate Date
     */
    public void createFile(Date startDate, Date stopDate) {
        List<ReportProductVo> list = 
            reportsService.getReportDomainCapability().getProductProposedInactivationDate(startDate, stopDate);

        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(PATH + FILENAME));

            //Write Column Headers
            writer.append("PRODUCT NAME" + ROW_FIELD_SEPARATOR);
            writer.append("PROPOSED INACTIVATION DATE" + ROW_FIELD_SEPARATOR);
            writer.append("COUNT OF ACTIVE NDCs");
            writer.newLine();

            for (ReportProductVo vo : list) {
                writer.append(vo.getVaProductName() + ROW_FIELD_SEPARATOR);
                writer.append(vo.getProposedInactionDate().toString() + ROW_FIELD_SEPARATOR);
                writer.append(vo.getActiveNdcsCount().toString());
                writer.newLine();
            }

        } catch (IOException e) {
            LOG.info("Create File IOException: " + e);
        }
        finally{
            safeFlush(writer);
            safeClose(writer);             
        }
    }

}
