
package gov.va.med.pharmacy.peps.service.common.utility;


/**
 *Provide output file mapping for warning label data
 */
public class NdfUpdatePlblwarningsMapping extends NDFUpdateFileMapping {
    
    public static final String PLBLW_ENGLISH_FILE_NUMBER = "50.625";
    public static final String PLBLW_SPANISH_FILE_NUMBER = "50.626";
    public static final String PLBLW_MAP_FILE = "50.627";    
    public static final String PLBLW_WARNING_LABEL_HEADER = "WARNING LABEL-";
    public static final String PLBLW_WARNING_LABEL_MAP_HEADER = "WARNING LABEL MAP^";

    public String formatDataRowForHeader(long titleLineCount, long linesOfTextCount)
    {
        return PLBLW_WARNING_LABEL_HEADER + getLanguageHeader() + ROW_FIELD_SEPARATOR + getVistaFile() + 
            ROW_FIELD_SEPARATOR + titleLineCount + ROW_FIELD_SEPARATOR + linesOfTextCount;
    }
    
    public String formatHeaderRowForLwid(int count)
    {
        return PMI + getVistaFile() + ROW_FIELD_SEPARATOR + count + ENDER;
    }
    
    public String formatHeaderRowForDateStamp(String lWId){
        Long lwid = new Long(lWId);
        return PMI + getVistaFile() + ROW_FIELD_SEPARATOR + lwid + ROW_FIELD_SEPARATOR + ONE + ENDER;
    }
    
    public String formatDataRowForDateStamp(long lineCount){
        return DOUBLE_ROW_FIELD_SEPARATOR + lineCount + ROW_FIELD_SEPARATOR + lineCount +
            ROW_FIELD_SEPARATOR + getVistaDate();
    }
    
    public String formatHeaderRowForText(String lWId, int lineCount){
        Long lwid = new Long(lWId);
        return PMI + getVistaFile() + ROW_FIELD_SEPARATOR + lwid + ROW_FIELD_SEPARATOR + ONE + ROW_FIELD_SEPARATOR + lineCount + ENDER;
    }
    
    public String formatLwidMapRow(String lWId, int lineCount){
        
        return PMI + getVistaFile() + ROW_FIELD_SEPARATOR + BLANK_INDICATOR + ROW_FIELD_SEPARATOR + lWId + ROW_FIELD_SEPARATOR + lineCount;
    }
   
    public String formatPmiRowForMap(){
        
        return PMI +  PLBLW_MAP_FILE + ENDER;
    }
    
    public String formatDataRowForMapHeader(int maxGcn, int gcnCount){
        
        return PLBLW_WARNING_LABEL_MAP_HEADER + PLBLW_MAP_FILE + ROW_FIELD_SEPARATOR + maxGcn + ROW_FIELD_SEPARATOR + gcnCount;
    }
    
    public String formatPmiRowForMapData(int lineCount){
        
        return PMI + PLBLW_MAP_FILE + ROW_FIELD_SEPARATOR + lineCount + ENDER;
    }
    
    public String formatDataRowForMapData(Long gcnSeqNo, String lwId, Long priority){
       
        return String.format("%06d",gcnSeqNo) + ROW_FIELD_SEPARATOR + lwId + ROW_FIELD_SEPARATOR + String.format("%02d",priority);
    }  
    
    public String formatAllGcnsMapRow(Long lWId, int lineCount){
        
        return PMI + getVistaMapFile() + ROW_FIELD_SEPARATOR + BLANK_INDICATOR + ROW_FIELD_SEPARATOR + String.format("%06d",lWId) + ROW_FIELD_SEPARATOR + lineCount;
    }
    
    public void setPlblWOutputLanguageType(long languageId){
       
        setVistaMapFile(PLBLW_MAP_FILE);
        if(languageId == 1)
        {
            setVistaFile(PLBLW_ENGLISH_FILE_NUMBER);
            setLanguageHeader(ENGLISH_HEADER);
        }else{
            setVistaFile(PLBLW_SPANISH_FILE_NUMBER);
            setLanguageHeader(SPANISH_HEADER);
            setIsEnglish(false);
        }
    }
}
