package gov.va.med.pharmacy.peps.service.common.utility;

import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;
import gov.va.med.pharmacy.peps.external.common.utility.MumpsConverter;


/**
 *Provide output file mapping for VA Product data
 */
public class NdfUpdateNdfDataMapping extends NDFUpdateFileMapping {

    public String formatHeaderRowForDATANT(String vistaFileNumber, int count){
        return DATANT +  vistaFileNumber + ROW_FIELD_SEPARATOR + count;
    }
    
    public String formatIenRowForDATANT(EplNdfOutgoingDifferences difference){
       return difference.getVistaIen() + ROW_FIELD_SEPARATOR + MumpsConverter.convertDateTime(difference.getCreatedDtm()) 
            + ROW_FIELD_SEPARATOR + difference.getVistaFieldNumber() + ROW_FIELD_SEPARATOR + 
            USER + ROW_FIELD_SEPARATOR + "A";
    }
    
    public String formatHeaderRowForDATAN(String vistaFileNumber, int count){

        return DATAN + vistaFileNumber + ROW_FIELD_SEPARATOR + count;
    }
    
    public String formatIenRowForDATAN(EplNdfOutgoingDifferences difference){
       return difference.getVistaIen() + ROW_FIELD_SEPARATOR + MumpsConverter.convertDateTime(difference.getCreatedDtm()) 
            + ROW_FIELD_SEPARATOR + difference.getVistaFieldNumber() + ROW_FIELD_SEPARATOR + 
            USER + ROW_FIELD_SEPARATOR + "A";
    }
    
    public String formatHeaderRowForDATAO(String vistaFileNumber, int count){
        return DATAO +  ROW_FIELD_SEPARATOR + vistaFileNumber + ROW_FIELD_SEPARATOR + count;
    }
    
    public String formatIenRowForDATAO(EplNdfOutgoingDifferences difference){
        return difference.getVistaIen() + ROW_FIELD_SEPARATOR + MumpsConverter.convertDateTime(difference.getCreatedDtm()) + ROW_FIELD_SEPARATOR + 
            difference.getVistaFieldNumber() + ROW_FIELD_SEPARATOR + USER;
    }
}
