
package gov.va.med.pharmacy.peps.service.common.utility;

import gov.va.med.pharmacy.peps.common.vo.FdbMonographPemVVo;


/**
 * Provide output file mapping for PMI data
 */
public class NdfUpdateMonographPemMapping extends NDFUpdateFileMapping {
    
    public static final String PEM_ENGLISH_FILE_NUMBER = "50.621";
    public static final String PEM_SPANISH_FILE_NUMBER = "50.622";
    public static final String PEM_ENGLISH_MAP_FILE_NUMBER = "50.623";
    public static final String PEM_SPANISH_MAP_FILE_NUMBER = "50.624";
    
    public static final String PMI_HEADER = "PMI-";
    public static final String PMI_HEADER_2 = "^.5";
    public static final String PMI_MAP_HEADER = "PMI MAP-";
 
    //Begin Monograph text mapping

    public String formatDataRowForPmiHeader(long titleLineCount, long totalMonographIds)
    {
        return PMI_HEADER + getLanguageHeader() + ROW_FIELD_SEPARATOR + getVistaFile() + ROW_FIELD_SEPARATOR +
            titleLineCount + ROW_FIELD_SEPARATOR  + totalMonographIds;
    }
    
    public String formatPmiRowForPmiTimeStamp()
    {  
            return PMI + getVistaFile() + PMI_HEADER_2 + ENDER;
    }
    
    public String formatDataRowForPmiDateStamp()
    {  
            return getVistaDate();
    }
    
    public String formatPmiRowForTitle(long monographId){
        return PMI + getVistaFile() + ROW_FIELD_SEPARATOR +  
            + monographId + ENDER ;
    }   
    
    public String formatPmiRowForTitleDateStamp(long monographId){
        return PMI + getVistaFile() + ROW_FIELD_SEPARATOR + monographId + ENDER;
    } 
    
    public String formatPmiRowForTextDateStamp(long monographId, String sectionCode){
        return PMI + getVistaFile() + ROW_FIELD_SEPARATOR + monographId + ROW_FIELD_SEPARATOR + sectionCode  + ENDER;
    }   
    
    public String formatDataRowForTextDateStamp(long sectionCount){
        return DOUBLE_ROW_FIELD_SEPARATOR + sectionCount + ROW_FIELD_SEPARATOR 
            + sectionCount + ROW_FIELD_SEPARATOR + getVistaDate();
    }
    
    public String formatPmiRowForText(long monographId, String sectionCode, int lineCount){
        return PMI + getVistaFile() + ROW_FIELD_SEPARATOR + monographId + ROW_FIELD_SEPARATOR 
            +  sectionCode  + ROW_FIELD_SEPARATOR + lineCount + ENDER;
    }
    
//Begin map formatting
    //monograph title list
    public String formatRowForMonographTitleGcn(FdbMonographPemVVo monograph){
        return PMI + getVistaFile() + ROW_FIELD_SEPARATOR + BLANK_INDICATOR + ROW_FIELD_SEPARATOR   
            + monograph.getLineText() + ROW_FIELD_SEPARATOR + monograph.getMonographId();
    }
    public String formatPmiRowForMapHeader()
    {
        return PMI + getVistaMapFile() + ENDER;
    }
    
    public String formatDataRowForMapHeader(long maxMonographId, long totalMonographIds)
    {
        return PMI_MAP_HEADER + getLanguageHeader() + ROW_FIELD_SEPARATOR + getVistaMapFile() + ROW_FIELD_SEPARATOR +
            maxMonographId + ROW_FIELD_SEPARATOR  + totalMonographIds;
    }
    
  //
    public String formatPmiRowForGcnMonographMap(int lineCount){
        return PMI + getVistaMapFile() + ROW_FIELD_SEPARATOR + lineCount + ENDER;
    }
    
    //
    public String formatDataRowForGcnMonographMap(Long gcnSeqNo, Long monographId){
        return  String.format("%06d",gcnSeqNo) + ROW_FIELD_SEPARATOR + String.format("%04d",monographId);
    }
    
    //
    public String formatHeaderMonographIdCountRow(Long maxGcn, Long totalMonographs){
        return PMI + getVistaMapFile() + ROW_FIELD_SEPARATOR + BLANK_INDICATOR + ROW_FIELD_SEPARATOR 
            + maxGcn.toString() + ROW_FIELD_SEPARATOR + totalMonographs;
    }  
  //
    public String formatMonographIdCountRow(Long monographId, int lineCount){
        return PMI + getVistaMapFile() + ROW_FIELD_SEPARATOR + BLANK_INDICATOR + ROW_FIELD_SEPARATOR 
            + String.format("%06d",monographId) + ROW_FIELD_SEPARATOR + lineCount;
    }
    
    public void setPemOutputLanguageType(Long languageId){
        if(languageId == 1)
        {
            setVistaFile(PEM_ENGLISH_FILE_NUMBER);
            setVistaMapFile(PEM_ENGLISH_MAP_FILE_NUMBER);
            setLanguageHeader(ENGLISH_HEADER);
        }else{
            setVistaFile(PEM_SPANISH_FILE_NUMBER);
            setVistaMapFile(PEM_SPANISH_MAP_FILE_NUMBER);
            setLanguageHeader(SPANISH_HEADER);
            setIsEnglish(false);
        }
    }

}
