package gov.va.med.pharmacy.peps.service.common.utility;


public class NdfUpdateMessageUtility extends NDFUpdateFileMapping{
    
    final static String newLine = System.getProperty("line.separator");
    final static String spacer = "     ";
    final static String spacer2 = "          ";
    final static String spacer3 = "                 ";
    final static String doubledSpace = "    ";
    final static String space = "  ";    
    
    public static StringBuffer starterMESSAGE(StringBuffer message, String date){
        message.append(MESSAGE+"0^0");
        message.append(newLine);
        message.append("^^xxx^xxx^" + date);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer starterMESSAGE2(StringBuffer message, String date){
        message.append(MESSAGE2+"0^0");
        message.append(newLine);
        message.append("^^xxx^xxx^" + date);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatHeaderRowForMESSAGEEnd(int counter, StringBuffer message){
        message.append(MESSAGE + counter + ENDER);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatHeaderRowForMESSAGEStart(int counter, StringBuffer message){        
        message.append(newLine);
        message.append(MESSAGE + counter + ENDER);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatHeaderRowForMESSAGE2End(int counter, StringBuffer message){
        message.append(MESSAGE2 + counter + ENDER);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatHeaderRowForMESSAGE2Start(int counter, StringBuffer message){
        message.append(newLine);
        message.append(MESSAGE2 + counter + ENDER);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatDataRowForMESSAGE(String data, StringBuffer message){
        message.append(doubledSpace +data);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatDataRowForInnerTitle(String data, StringBuffer message){
        message.append(space +data);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatTitleDataRowForMESSAGE(String data, StringBuffer message){        
        message.append(data);
        message.append(newLine);
        return message;
    }  
    
    public static StringBuffer formatOldDataRowForMESSAGE(String data, StringBuffer message){
        message.append(OLD + data);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatNewDataRowForMESSAGE(String data, StringBuffer message){
        message.append(NEW + data);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatAddLine(StringBuffer message){        
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatAddData(String data, StringBuffer message){        
        message.append(doubledSpace + data);
        return message;
    }
    
    public static StringBuffer formatAddHeaderLine(StringBuffer message){        
        message.append(BORDER);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatDataEndMESSAGE(int counter,StringBuffer message){        
        message.append("MESSAGE^" + counter + "^0");
        message.append(newLine);
        message.append(" ");
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatParallelDataSqr(String data1, String data2, StringBuffer message){        
        message.append(doubledSpace + data1);
        message.append(spacer);
        message.append("[" + data2 + "]");
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatParallelDataNone(String data1, String data2, StringBuffer message){        
        message.append(doubledSpace + data1);
        message.append(spacer);
        message.append(data2);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatParallelData(String data1, String data2, StringBuffer message){        
        message.append(doubledSpace + data1);
        message.append(spacer2);
        message.append(data2);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatParallelDataNoLine(String data1, String data2, StringBuffer message){        
        message.append(doubledSpace + data1);
        message.append(spacer2);
        message.append(data2);        
        return message;
    }
    
    public static StringBuffer formatParallelDataSpace(String data1, String data2, StringBuffer message){        
        message.append(doubledSpace + data1);
        message.append(spacer3);
        message.append(data2);
        message.append(newLine);
        return message;
    }
    
    public static StringBuffer formatSpaceData(String data,StringBuffer message){  
        message.append(spacer);
        message.append(data);        
        return message;
    }
    
    public static StringBuffer formatNewLineData(String data,StringBuffer message){  
        message.append(newLine);
        message.append(data);        
        return message;
    }
    
    public static StringBuffer totalLineUpdate(int counter, StringBuffer message){
        int finalMessageLineCount = message.indexOf("xxx^xxx");            
        message.replace(finalMessageLineCount, finalMessageLineCount + 7, counter + "^" + counter);
        return message;
    }

}
