package gov.va.med.pharmacy.peps.service.common.utility;

import gov.va.med.pharmacy.peps.external.common.utility.MumpsConverter;

import java.util.GregorianCalendar;


/**
 * Provide output file mapping for NDF output file
 */
public abstract class NDFUpdateFileMapping {
 
    public static final String ENGLISH_HEADER = "ENGLISH";
    public static final String SPANISH_HEADER = "SPANISH";
    public static final String ROW_FIELD_SEPARATOR = "^";
    public static final String DOUBLE_ROW_FIELD_SEPARATOR = "^^";
    public static final String BLANK_INDICATOR = "B";
    public static final String TITLE_INDICATOR = "T";
    public static final String PMI = "PMIDATA^";
    public static final String TEMP = "TEMP^";
    public static final String DATA = "DATA^";
    public static final String DATANT = "DATANT^";
    public static final String DATAN = "DATAN^";
    public static final String DATAO = "DATAO";
    public static final String QUOTE = "\"";
    public static final String USER = "360";
    public static final String ENDER = "^0";
    public static final String DATA_SEPARATOR = "|";
    public static final String ONE = "1";
    public static final String MESSAGE = "MESSAGE^";   
    public static final String OLD = "      Old Value: ";
    public static final String NEW = "      New Value: ";
    public static final String MESSAGE2 = "MESSAGE2^";
    public static final String BORDER = "==========";
    public static boolean isEnglish = true;
    
    private String vistaFile;
    private String vistaMapFile;
    private String languageHeader;
    
    public String formatTempRowForHeader()
    {
        return PMI + getVistaFile() + ENDER;
    }
    
    public void setIsEnglish(boolean b) {
        isEnglish = b;
    }
    
    /**
     * @return the vistaFile
     */
    public String getVistaFile() {
        return vistaFile;
    }

    
    /**
     * @param vistaFile the vistaFile to set
     */
    public void setVistaFile(String vistaFile) {
        this.vistaFile = vistaFile;
    }

    
    /**
     * @return the vistaMapFile
     */
    public String getVistaMapFile() {
        return vistaMapFile;
    }

    
    /**
     * @param vistaMapFile the vistaMapFile to set
     */
    public void setVistaMapFile(String vistaMapFile) {
        this.vistaMapFile = vistaMapFile;
    }

    
    /**
     * @return the pmiLanguageHeader
     */
    public String getLanguageHeader() {
        return languageHeader;
    }

    
    /**
     * @param pmiLanguageHeader the pmiLanguageHeader to set
     */
    public void setLanguageHeader(String pmiLanguageHeader) {
        this.languageHeader = pmiLanguageHeader;
    }
    
    /**
     * 
     */
    public String getVistaTimeStamp() {

        GregorianCalendar calendar = new GregorianCalendar();
        return MumpsConverter.convertDateTime(calendar.getTime());

    }
    
    /**
    *
    */
   public String getVistaDate() {

       GregorianCalendar calendar = new GregorianCalendar();
       return MumpsConverter.convertDate(calendar.getTime());

   }
}


