package gov.va.med.pharmacy.peps.service.common.utility;

import gov.va.med.pharmacy.peps.external.common.utility.MumpsConverter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class MessageFormatter {

    private Date messageDate = null;
    private List<String> plainMessages = new ArrayList<String>();

    public MessageFormatter(Date d, List<String> messageData) {
        messageDate = d;
        plainMessages.addAll(messageData);
    }

    public MessageFormatter(Date d, String... messageData) {
        this(d, Arrays.asList(messageData));
    }

    public List<String> apply(String tag) {
        List<String> result = new ArrayList<String>();

        // add overall message header..
        result.addAll(getMessageHeader(tag));

        for (int i=0; i < plainMessages.size(); i++) {
            result.add(tag + (i+1) + NDFUpdateFileMapping.ENDER);
            result.add(plainMessages.get(i));
        }
        return result;
    }

    private String getMumpsFormattedDateString() {
        return MumpsConverter.convertDate(messageDate);
    }

    private List<String> getMessageHeader(String tag) {
        List<String> result = new ArrayList<String>();
        result.add(tag + "0"
                + NDFUpdateFileMapping.ENDER);
        result.add(NDFUpdateFileMapping.DOUBLE_ROW_FIELD_SEPARATOR
                + plainMessages.size()
                + NDFUpdateFileMapping.ROW_FIELD_SEPARATOR
                + plainMessages.size()
                + NDFUpdateFileMapping.ROW_FIELD_SEPARATOR 
                + getMumpsFormattedDateString());
        return result;
    }

}
