package gov.va.med.pharmacy.peps.service.common.utility;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;



/**
 * The Class FileInfo.
 */
public class FileInfo {

    
    /** The Constant SFTP_URL_PREFIX. */
    private static final String SFTP_URL_PREFIX = "sftp://";
    
    /** The Constant AT_SIGN. */
    private static final String AT_SIGN = "@";
    
    /** The Constant COLON. */
    private static final String COLON = ":";
    
    /** The file name. */
    private String fileName;
    
    /** The host name. */
    private String hostName;
    
    /** The port. */
    private String port;
    
    /** The user name. */
    private String userName;
    
    /** The authorization. */
    private String authorization;
    
    /** The directory path. */
    private String directoryPath;
    
   
    /**
     * Gets the file name.
     *
     * @return the file name
     */
    public final String getFileName() {
        return fileName;
    }

    /**
     * Sets the file name.
     *
     * @param fileName the new file name
     */
    public final void setFileName(String fileName) {
        this.fileName = fileName;
    }
    
    /**
     * Gets the host name.
     *
     * @return the host name
     */
    public final String getHostName() {
        return hostName;
    }

    /**
     * Sets the host name.
     *
     * @param hostName the new host name
     */
    public final void setHostName(String hostName) {
        this.hostName = hostName;
    }

    /**
     * Gets the port.
     *
     * @return the port
     */
    public final String getPort() {
        return port;
    }

    /**
     * Sets the port.
     *
     * @param port the new port
     */
    public final void setPort(String port) {
        this.port = port;
    }

    /**
     * Gets the user name.
     *
     * @return the user name
     */
    public final String getUserName() {
        return userName;
    }

    /**
     * Sets the user name.
     *
     * @param userName the new user name
     */
    public final void setUserName(String userName) {
        this.userName = userName;
    }

    /**
     * Gets the authorization.
     *
     * @return the authorization
     */
    public final String getAuthorization() {
        return authorization;
    }

    /**
     * Sets the authorization.
     *
     * @param authorization the new authorization
     */
    public final void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    /**
     * Gets the directory path.
     *
     * @return the directory path
     */
    public final String getDirectoryPath() {
        return directoryPath;
    }

    /**
     * Sets the directory path.
     *
     * @param directoryPath the new directory path
     */
    public final void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
    }

    /**
     * Gets the encoded uri directory.
     *
     * @return the encoded uri directory
     */
    public final String getEncodedURIDirectory() {
        String encodedUser = null;
        String encodedAuthorization = null;
        try {
            encodedUser = URLEncoder.encode(getUserName(), "UTF-8");
            encodedAuthorization = URLEncoder.encode(getAuthorization(), "UTF-8");
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        String uri =
                SFTP_URL_PREFIX 
                + encodedUser 
                + COLON 
                + encodedAuthorization 
                + AT_SIGN 
                + getHostName() 
                + COLON
                        + getPort() 
                        + getDirectoryPath();

        return uri;
    }
    
    /**
     * Gets the encoded file path.
     *
     * @return the encoded file path
     */
    public final String getEncodedFilePath(){
        String filePath = getEncodedURIDirectory() + getFileName();
        return filePath;
    }

}
