package gov.va.med.pharmacy.peps.service.common.session.impl;

import gov.va.med.pharmacy.peps.common.vo.UpdateSiteVo;
import gov.va.med.pharmacy.peps.service.common.session.VistaUpdateSitesService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;


// now local vista update sites info is hard coded here.  Later it is likely this info should be
// put in the database for easier update of sites.  So the functionality to find site name and sites
// out of compliance is wrapped up in this service for easier modificatiofn later.

public class VistaUpdateSitesServiceImpl implements VistaUpdateSitesService {

    private final static Map<Long, String> VISTA_UPDATE_SITES = new HashMap<Long, String>();
    static {
        VISTA_UPDATE_SITES.put(501L, "ALBUQUERQUE, NM");
        VISTA_UPDATE_SITES.put(502L, "ALEXANDRIA, LA");
        VISTA_UPDATE_SITES.put(503L, "ALTOONA, PA");
        VISTA_UPDATE_SITES.put(504L, "AMARILLO, TX");
        VISTA_UPDATE_SITES.put(463L, "ANCHORAGE, AK (OPC)");
        VISTA_UPDATE_SITES.put(506L, "ANN ARBOR, MI");
        VISTA_UPDATE_SITES.put(637L, "ASHEVILLE, NC");
        VISTA_UPDATE_SITES.put(508L, "ATLANTA, GA");
        VISTA_UPDATE_SITES.put(509L, "AUGUSTA, GA (C)");
        VISTA_UPDATE_SITES.put(515L, "BATTLE CREEK, MI");
        VISTA_UPDATE_SITES.put(516L, "BAY PINES, FL");
        VISTA_UPDATE_SITES.put(517L, "BECKLEY, WV");
        VISTA_UPDATE_SITES.put(518L, "BEDFORD, MA");
        VISTA_UPDATE_SITES.put(519L, "BIG SPRING, TX");
        VISTA_UPDATE_SITES.put(520L, "BILOXI, MS (C)");
        VISTA_UPDATE_SITES.put(521L, "BIRMINGHAM, AL");
        VISTA_UPDATE_SITES.put(568L, "BLACK HILLS HCS");
        VISTA_UPDATE_SITES.put(531L, "BOISE, ID");
        VISTA_UPDATE_SITES.put(523L, " BOSTON HCS");
        VISTA_UPDATE_SITES.put(526L, " BRONX, NY");
        VISTA_UPDATE_SITES.put(529L, "BUTLER, PA");
        VISTA_UPDATE_SITES.put(619L, "CENTRAL ALABAMA HCS");
        VISTA_UPDATE_SITES.put(636L, "CENTRAL PLAINS HCS");
        VISTA_UPDATE_SITES.put(674L, "CENTRAL TEXAS HCS");
        VISTA_UPDATE_SITES.put(534L, "CHARLESTON, SC");
        VISTA_UPDATE_SITES.put(442L, "CHEYENNE, WY");
        VISTA_UPDATE_SITES.put(537L, "CHICAGO HCS");
        VISTA_UPDATE_SITES.put(538L, "CHILLICOTHE, OH");
        VISTA_UPDATE_SITES.put(539L, "CINCINNATI, OH");
        VISTA_UPDATE_SITES.put(540L, "CLARKSBURG, WV");
        VISTA_UPDATE_SITES.put(541L, "CLEVELAND, OH");
        //VISTA_UPDATE_SITES.put("", "CMOP-NATIONAL");
        VISTA_UPDATE_SITES.put(542L, "COATESVILLE, PA");
        VISTA_UPDATE_SITES.put(544L, "COLUMBIA, SC");
        VISTA_UPDATE_SITES.put(757L, "COLUMBUS, OH(OPC)");
        VISTA_UPDATE_SITES.put(689L, "CONNECTICUT HCS");
        VISTA_UPDATE_SITES.put(552L, "DAYTON, OH");
        VISTA_UPDATE_SITES.put(553L, "DETROIT, MI");
        VISTA_UPDATE_SITES.put(557L, "DUBLIN, GA");
        VISTA_UPDATE_SITES.put(558L, "DURHAM, NC");
        VISTA_UPDATE_SITES.put(554L, "EASTERN COLORADO HCS");
        VISTA_UPDATE_SITES.put(756L, "EL PASO, TX");
        VISTA_UPDATE_SITES.put(562L, "ERIE, PA");
        VISTA_UPDATE_SITES.put(437L, "FARGO, ND");
        VISTA_UPDATE_SITES.put(564L, "FAYETTEVILLE, AR");
        VISTA_UPDATE_SITES.put(565L, "FAYETTEVILLE, NC");
        VISTA_UPDATE_SITES.put(570L, "FRESNO, CA");
        VISTA_UPDATE_SITES.put(575L, "GRAND JUNCTION, CO");
        VISTA_UPDATE_SITES.put(590L, "HAMPTON, VA");
        //VISTA_UPDATE_SITES.put("", "HEALTH ADMIN CENTER, CO");
        VISTA_UPDATE_SITES.put(657L, "HEARTLAND-EAST HCS");
        VISTA_UPDATE_SITES.put(589L, "HEARTLAND-WEST HCS");
        VISTA_UPDATE_SITES.put(578L, "HINES, IL");
        VISTA_UPDATE_SITES.put(459L, "HONOLULU, HI");
        VISTA_UPDATE_SITES.put(580L, "HOUSTON, TX");
        VISTA_UPDATE_SITES.put(620L, "HUDSON VALLEY HCS");
        VISTA_UPDATE_SITES.put(581L, "HUNTINGTON, WV");
        VISTA_UPDATE_SITES.put(550L, "ILLIANA HCS");
        VISTA_UPDATE_SITES.put(583L, "INDIANAPOLIS, IN (C)");
        VISTA_UPDATE_SITES.put(585L, "IRON MOUNTAIN, MI");
        VISTA_UPDATE_SITES.put(586L, "JACKSON, MS");
        VISTA_UPDATE_SITES.put(593L, "LAS VEGAS, NV");
        VISTA_UPDATE_SITES.put(595L, "LEBANON, PA");
        VISTA_UPDATE_SITES.put(596L, "LEXINGTON, KY");
        VISTA_UPDATE_SITES.put(598L, "LITTLE ROCK, AR (C)");
        VISTA_UPDATE_SITES.put(605L, "LOMA LINDA, CA");
        VISTA_UPDATE_SITES.put(600L, "LONG BEACH, CA");
        VISTA_UPDATE_SITES.put(603L, "LOUISVILLE, KY");
        VISTA_UPDATE_SITES.put(607L, "MADISON, WI");
        VISTA_UPDATE_SITES.put(608L, "MANCHESTER, NH");
        VISTA_UPDATE_SITES.put(358L, "MANILA OC, PI");
        VISTA_UPDATE_SITES.put(613L, "MARTINSBURG, WV");
        VISTA_UPDATE_SITES.put(512L, "MARYLAND HCS");
        VISTA_UPDATE_SITES.put(614L, "MEMPHIS, TN");
        VISTA_UPDATE_SITES.put(546L, "MIAMI, FL");
        VISTA_UPDATE_SITES.put(695L, "MILWAUKEE, WI");
        VISTA_UPDATE_SITES.put(618L, "MINNEAPOLIS, MN");
        VISTA_UPDATE_SITES.put(436L, "MONTANA HCS");
        VISTA_UPDATE_SITES.put(621L, "MOUNTAIN HOME, TN");
        VISTA_UPDATE_SITES.put(623L, "MUSKOGEE, OK");
        VISTA_UPDATE_SITES.put(561L, "NEW JERSEY HCS");
        VISTA_UPDATE_SITES.put(629L, "NEW ORLEANS, LA");
        VISTA_UPDATE_SITES.put(630L, "NEW YORK HCS");
        VISTA_UPDATE_SITES.put(556L, "NORTH CHICAGO, IL");
        VISTA_UPDATE_SITES.put(573L, "NORTH FLORIDA/SOUTH GEORGIA");
        VISTA_UPDATE_SITES.put(549L, "NORTH TEXAS HCS");
        VISTA_UPDATE_SITES.put(631L, "NORTHAMPTON, MA");
        VISTA_UPDATE_SITES.put(612L, "NORTHERN CALIFORNIA HCS");
        VISTA_UPDATE_SITES.put(610L, "NORTHERN INDIANA HCS");
        VISTA_UPDATE_SITES.put(632L, "NORTHPORT, NY");
        VISTA_UPDATE_SITES.put(635L, "OKLAHOMA CITY, OK");
        VISTA_UPDATE_SITES.put(675L, "ORLANDO, FL");
        VISTA_UPDATE_SITES.put(640L, "PALO ALTO HCS");
        VISTA_UPDATE_SITES.put(642L, "PHILADELPHIA, PA");
        VISTA_UPDATE_SITES.put(644L, "PHOENIX, AZ");
        VISTA_UPDATE_SITES.put(646L, "PITTSBURGH HCS");
        VISTA_UPDATE_SITES.put(648L, "PORTLAND, OR (C)");
        VISTA_UPDATE_SITES.put(649L, "PRESCOTT, AZ");
        VISTA_UPDATE_SITES.put(650L, "PROVIDENCE, RI");
        VISTA_UPDATE_SITES.put(663L, "PUGET SOUND HCS");
        VISTA_UPDATE_SITES.put(654L, "RENO, NV");
        VISTA_UPDATE_SITES.put(652L, "RICHMOND, VA");
        VISTA_UPDATE_SITES.put(653L, "ROSEBURG, OR");
        VISTA_UPDATE_SITES.put(655L, "SAGINAW, MI");
        VISTA_UPDATE_SITES.put(658L, "SALEM, VA");
        VISTA_UPDATE_SITES.put(659L, "SALISBURY, NC");
        VISTA_UPDATE_SITES.put(660L, "SALT LAKE CITY, UT");
        VISTA_UPDATE_SITES.put(664L, "SAN DIEGO, CA");
        VISTA_UPDATE_SITES.put(662L, "SAN FRANCISCO, CA");
        VISTA_UPDATE_SITES.put(672L, "SAN JUAN, PR");
        VISTA_UPDATE_SITES.put(666L, "SHERIDAN, WY");
        VISTA_UPDATE_SITES.put(667L, "SHREVEPORT, LA");
        VISTA_UPDATE_SITES.put(438L, "SIOUX FALLS, SD");
        VISTA_UPDATE_SITES.put(671L, "SOUTH TEXAS HCS");
        VISTA_UPDATE_SITES.put(668L, "SPOKANE, WA");
        VISTA_UPDATE_SITES.put(656L, "ST CLOUD, MN");
        VISTA_UPDATE_SITES.put(673L, "TAMPA, FL");
        VISTA_UPDATE_SITES.put(626L, "TENNESSEE VALLEY HCS");
        VISTA_UPDATE_SITES.put(740L, "TEXAS VALLEY COASTAL BEND HCS");
        VISTA_UPDATE_SITES.put(402L, "TOGUS, ME");
        VISTA_UPDATE_SITES.put(676L, "TOMAH, WI");
        VISTA_UPDATE_SITES.put(678L, "TUCSON, AZ");
        VISTA_UPDATE_SITES.put(679L, "TUSCALOOSA, AL");
        VISTA_UPDATE_SITES.put(528L, "UPSTATE NEW YORK HCS");
        VISTA_UPDATE_SITES.put(691L, "VA GREATER LOS ANGELES HCS");
        VISTA_UPDATE_SITES.put(687L, "WALLA WALLA, WA");
        VISTA_UPDATE_SITES.put(688L, "WASHINGTON, DC");
        VISTA_UPDATE_SITES.put(548L, "WEST PALM BEACH, FL");
        VISTA_UPDATE_SITES.put(692L, "WHITE CITY, OR (DOM)");
        VISTA_UPDATE_SITES.put(405L, "WHITE RIVER JUNCTION, VT");
        VISTA_UPDATE_SITES.put(693L, "WILKES BARRE, PA");
        VISTA_UPDATE_SITES.put(460L, "WILMINGTON, DE");
    }
    
    public String getNameBySiteNumber(Long siteNbr) {
        String name = VISTA_UPDATE_SITES.get(siteNbr);
        if (name == null) {
            name = "Site Name Unknown for " + siteNbr;
        }
        return name;
    }
    
    public List<UpdateSiteVo> findSitesOutOfCompliances(List<Long> siteNbrs) {
        List<UpdateSiteVo> sitesOutOfCompliacne = new ArrayList<UpdateSiteVo>();
        Iterator<Map.Entry<Long, String>> iter =  VISTA_UPDATE_SITES.entrySet().iterator();
        while(iter.hasNext()) {
            Map.Entry<Long, String> entry = iter.next();
            if (!siteNbrs.contains(entry.getKey())) {
                sitesOutOfCompliacne.add(new UpdateSiteVo(entry.getKey(), entry.getValue()));
            }
        }
        return sitesOutOfCompliacne;
    }
}
