/**
 * 
 */


package gov.va.med.pharmacy.peps.service.common.session.impl;


import gov.va.med.pharmacy.peps.common.exception.ValidationException;
import gov.va.med.pharmacy.peps.common.exception.ValueObjectValidationException;
import gov.va.med.pharmacy.peps.common.object.VistaStatus;
import gov.va.med.pharmacy.peps.common.vo.EplVistaUpdateVo;
import gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileVo;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.capability.VistaUpdateCapability;
import gov.va.med.pharmacy.peps.domain.common.model.EplVistaStatusDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplVistaUpdateDo;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.NdfUpdateFileConverter;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.StatusConverter;
import gov.va.med.pharmacy.peps.service.common.capability.NdfUpdateCapability;
import gov.va.med.pharmacy.peps.service.common.session.VistaUpdateService;

import javax.annotation.Resource;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;


/**
 * Implementation of VistaUpdateService.
 */
@Service
public class VistaUpdateServiceImpl implements VistaUpdateService {

    /** The vista update capability. */
    @Resource
    private VistaUpdateCapability vistaUpdateCapability;
    
    /** The ndf update capability. */
    @Resource
    private NdfUpdateCapability ndfUpdateCapability;
    
   
    /**
     * Save the specified EplVistaUpdateVo.
     *
     * @param eplVistaUpdateVo the EplVistaUpdateVo to save
     * @throws ValidationException 
     * @throws ValidationException 
     */
    @Transactional(rollbackForClassName="gov.va.med.pharmacy.peps.common.exception.ValidationException")
    public void saveUpdate(EplVistaUpdateVo eplVistaUpdateVo) throws ValidationException {
        
        EplVistaUpdateDo vistaDao = saveUpdateVistaVo(eplVistaUpdateVo);  
        if (vistaDao != null) {
            NdfUpdateFileConverter converter = new NdfUpdateFileConverter();
            converter.setStatusConverter(new StatusConverter());
            NdfUpdateFileVo vo = converter.convert(vistaDao.getEplNdfUpdateFileDo());
            if (vo.getStatus().isRejectedByQA() || vo.getStatus().isVistaError()){
                // a bit ugly to get the user from here, but until more research can be done...
                UserVo user = new UserVo();
                user.setUsername(vo.getCreatedBy());
                //need to figure out what to do about exceptions
                try {
                    ndfUpdateCapability.reject(vo, user);
                } catch (ValueObjectValidationException e) {                   
                    //LOG.error("Exception squelched in saveUpdate()", e);
                    throw e;
                } catch (ValidationException e) {
                    //LOG.error("Exception squelched in saveUpdate()", e);
                    throw e;
                }
            }
        }
    }

    /**
     * Save the specified EplVistaUpdateVo.
     *
     * @param eplVistaUpdateVo the EplVistaUpdateVo to save
     * @return the EplVistaUpdateDo
     */    
    public EplVistaUpdateDo saveUpdateVistaVo(EplVistaUpdateVo eplVistaUpdateVo){
        EplVistaUpdateDo vistaDao = getVistaUpdateCapability().saveUpdate(eplVistaUpdateVo);
        return vistaDao;
    }
    
    /**
     * Gets the status by VistaStatus.
     *
     * @param vistaStatus the vista status
     * @return the status
     */
    @Transactional(readOnly = true)
    public EplVistaStatusDo getStatus(VistaStatus vistaStatus) {
        return getVistaUpdateCapability().getStatus(vistaStatus);
    }

    /**
     * Gets the vista update capability.
     *
     * @return the vistaUpdateCapability
     */
    @Override
    public VistaUpdateCapability getVistaUpdateCapability() {
        return vistaUpdateCapability;
    }

    /**
     * Sets the vista update capability.
     *
     * @param vistaUpdateCapability the vistaUpdateCapability to set
     */
    @Override
    public void setVistaUpdateCapability(VistaUpdateCapability vistaUpdateCapability) {
        this.vistaUpdateCapability = vistaUpdateCapability;
    }

    /**
     * Gets the ndf update capability.
     *
     * @return the ndfUpdateCapability
     */
    @Override
    public NdfUpdateCapability getNdfUpdateCapability() {
        return ndfUpdateCapability;
    }

    /**
     * Sets the ndf update capability.
     *
     * @param ndfUpdateCapability the ndfUpdateCapability to set
     */
    @Override
    public void setNdfUpdateCapability(NdfUpdateCapability ndfUpdateCapability) {
        this.ndfUpdateCapability = ndfUpdateCapability;
    }

    
}
