package gov.va.med.pharmacy.peps.service.common.session.impl;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileVo;
import gov.va.med.pharmacy.peps.common.vo.RematchSuggestionVo;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.service.common.capability.RematchSuggestionCapability;
import gov.va.med.pharmacy.peps.service.common.session.RematchSuggestionService;

@Service
public class RematchSuggestionServiceImpl implements RematchSuggestionService{
    
    @Autowired
    private RematchSuggestionCapability rematchSuggestionCapability;

    @Override
    @Transactional(readOnly=true)
    public List<RematchSuggestionVo> retrieveAllRematch() {
        
        return rematchSuggestionCapability.retrieveAllRematch();
        
    }

    
    public RematchSuggestionCapability getRematchSuggestionCapability() {
        return rematchSuggestionCapability;
    }

    
    public void setRematchSuggestionCapability(RematchSuggestionCapability rematchSuggestionCapability) {
        this.rematchSuggestionCapability = rematchSuggestionCapability;
    }


    @Override
    @Transactional(readOnly=false)
    public void removeObsoleteProducts() {
        rematchSuggestionCapability.removeObsoleteProducts();
        
    }
    
    
    @Override
    @Transactional
    public void addUnmatchedProducts(UserVo user) {
        rematchSuggestionCapability.addUnmatchedProducts(user);
    }  
    
    @Override
    @Transactional
    public List<RematchSuggestionVo> retrieveUnmatched(Long matchTypeId) {
        return rematchSuggestionCapability.retrieveUnmatched(matchTypeId);
    }   
    
    @Override
    @Transactional
    public Long retrieveProductId(String productIen) {
        return rematchSuggestionCapability.retrieveProductId(productIen);
    } 
    
    @Override
    @Transactional
    public List<Object[]> findRematchProducts(Long productId) {
        return rematchSuggestionCapability.findRematchProducts(productId);
    } 
    
    @Override
    @Transactional
    public void updateRematch(Long rematchId, String matchedProductIen, Boolean autoMatch) {
        rematchSuggestionCapability.updateRematch(rematchId, matchedProductIen, autoMatch);
    } 

}
