/**
 * Source file created in 2012 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.service.common.session.impl;


import java.util.Date;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.pharmacy.peps.common.vo.NationalSettingVo;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.capability.NationalSettingDomainCapability;
import gov.va.med.pharmacy.peps.service.common.session.NationalSettingService;


/**
 * NationalSettingServiceImpl's brief summary
 * 
 * Details of NationalSettingServiceImpl's operations, special dependencies
 * or protocols developers shall know about when using the class.
 *
 */
@Service
public class NationalSettingServiceImpl implements NationalSettingService {
    
    @Autowired
    private NationalSettingDomainCapability nationalSettingDomainCapability;

    @Override
    @Transactional
    public NationalSettingVo create(NationalSettingVo nationalSettingVo, UserVo user) {
        NationalSettingVo rv = nationalSettingDomainCapability.create(nationalSettingVo, user);
        
        return rv;
    }

    @Override
    @Transactional(readOnly=true)
    public NationalSettingVo retrieve(Long id) {
        return nationalSettingDomainCapability.retrieve(id);
    }

    @Override
    @Transactional(readOnly=true)
    public NationalSettingVo retrieve(String keyName) {
        return nationalSettingDomainCapability.retrieve(keyName);
    }

    @Override
    @Transactional(readOnly=true)
    public List<NationalSettingVo> retrieveAll() {
        return nationalSettingDomainCapability.retrieve();
    }

    @Override
    @Transactional(readOnly=true)
    public Boolean retrieveBoolean(String keyName) {
        return nationalSettingDomainCapability.retrieveBoolean(keyName);
    }

    @Override
    @Transactional(readOnly=true)
    public String retrieveString(String keyName) {
        return nationalSettingDomainCapability.retrieveString(keyName);
    }

    @Override
    @Transactional(readOnly=true)
    public Date retrieveDate(String keyName) {
        return nationalSettingDomainCapability.retrieveDate(keyName);
    }

    @Override
    @Transactional
    public void update(NationalSettingVo nationalSettingVo, UserVo user) {
        nationalSettingDomainCapability.update(nationalSettingVo, user);
    }

    @Override
    @Transactional
    public void delete(NationalSettingVo nationalSettingVo) {
        Long id = nationalSettingVo.getId();
        delete(id);
    }

    @Override
    @Transactional
    public void delete(Long id) {
        nationalSettingDomainCapability.delete(id);
    }

    @Override
    @Transactional
    public void delete(String keyName) {
        nationalSettingDomainCapability.delete(keyName);        
    }

    /**
     * getNationalSettingDomainCapability
     *
     * @return NationalSettingDomainCapability
     */
    public NationalSettingDomainCapability getNationalSettingDomainCapability() {
        
        return nationalSettingDomainCapability;
    }

    /**
     * setNationalSettingDomainCapability
     *
     * @param nationalSettingDomainCapability NationalSettingDomainCapability
     */
    public void setNationalSettingDomainCapability(NationalSettingDomainCapability nationalSettingDomainCapability) {
        this.nationalSettingDomainCapability = nationalSettingDomainCapability;        
    }

}
