

package gov.va.med.pharmacy.peps.service.common.session;


import gov.va.med.pharmacy.peps.common.exception.ValidationException;
import gov.va.med.pharmacy.peps.common.vo.EplVistaUpdateVo;
import gov.va.med.pharmacy.peps.domain.common.capability.VistaUpdateCapability;
import gov.va.med.pharmacy.peps.service.common.capability.NdfUpdateCapability;


/**
 * The Interface VistaUpdateService.
 */
public interface VistaUpdateService {

    /**
     * Save update.
     *
     * @param eplVistaUpdateVo the epl vista update vo
     * @return 
     * @throws ValidationException 
     */
    public void saveUpdate(EplVistaUpdateVo eplVistaUpdateVo) throws ValidationException;

    /**
     * Sets the vista update capability.
     *
     * @param vistaUpdateCapability the new vista update capability
     */
    public abstract void setVistaUpdateCapability(VistaUpdateCapability vistaUpdateCapability);

    /**
     * Gets the vista update capability.
     *
     * @return the vista update capability
     */
    public abstract VistaUpdateCapability getVistaUpdateCapability();
    
    /**
     * Gets the ndf update capability.
     *
     * @return the ndfUpdateCapability
     */
    public NdfUpdateCapability getNdfUpdateCapability();

    /**
     * Sets the ndf update capability.
     *
     * @param ndfUpdateCapability the ndfUpdateCapability to set
     */
    public void setNdfUpdateCapability(NdfUpdateCapability ndfUpdateCapability);
    
}
