package gov.va.med.pharmacy.peps.service.common.session;

import gov.va.med.pharmacy.peps.common.exception.ValidationException;
import gov.va.med.pharmacy.peps.common.exception.ValueObjectValidationException;
import gov.va.med.pharmacy.peps.common.vo.FieldKey;
import gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileActionVo;
import gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileVo;
import gov.va.med.pharmacy.peps.common.vo.PaginatedList;
import gov.va.med.pharmacy.peps.common.vo.StatusVo;
import gov.va.med.pharmacy.peps.common.vo.UpdateSearchCriteria;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.common.vo.validator.ErrorKey;
import gov.va.med.pharmacy.peps.common.vo.validator.Errors;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

/**
 * NDF Update File service to create, view, and update NdfUpdateFileVo
 */
public interface NDFUpdateFileService {
    
    /**
     * 
     * 
     * @return List<NdfUpdateFileVo> all UpdateFiles
     */
    List<NdfUpdateFileVo> retrieveFileUpdates();
    
    /**
     * 
     * 
     * @return List<NdfUpdateFileVo> all UpdateFiles
     */
    PaginatedList<NdfUpdateFileVo> retrievePagedFileUpdates(UpdateSearchCriteria searchCriteria);
    
    /**
     * 
     * 
     * @return List<NdfUpdateFileVo> pending UpdateFiles
     */
    List<NdfUpdateFileVo> retrievePendingNdfUpdate();
    
    /**
     * Updates the Ndf Update File 
     *
     * @param updatedNdfFile The file         
     * @param user the user logged in
     */
    void updateNdfUpdateFile(NdfUpdateFileVo updatedFile, UserVo user);
 
    
    /**
     * 
     * 
     * @return NdfUpdateFileVo pending UpdateFile
     */
    NdfUpdateFileVo retrieveById(Long id);
    
    /**
     * 
     * 
     * @return List<NdfUpdateFileVo> pending UpdateFiles
     */
    List<NdfUpdateFileVo> retrieveInitiatedNdfUpdate();
    
    /**
     * Updates the Ndf Update File 
     *
     * @param insertNdfFile The file         
     * @param user the user logged in
     */
    void insertNdfUpdateFile(NdfUpdateFileVo insertFile, UserVo user);

    /**
     *
     * @return List<StatusVo> all File Update Statuses 
     */
    List<StatusVo> retrieveAllFileStatuses();
    
    void processFileCreation(UserVo user);

    void removeNdfUpdateFileFk(Long id);

    void transmitToProd(NdfUpdateFileVo insertFile, UserVo user) throws ValidationException;
    
    void transmitToReject(NdfUpdateFileVo insertFile, UserVo user) throws ValidationException;
    
    NdfUpdateFileVo retrieveCurrentStatus();

    /**
     * Creates and stores an NdfUpdateFileVo with {@code StatusVo.INITIATED} status.
     * @param user
     * @return NdfUpdateFileVo the saved NdfUpdateFileVo with status {@code StatusVo.INITIATED}
     */

    NdfUpdateFileVo createInitiatedFile(UserVo user);

    /**
     * Approve.  Updates the status and transmits the file to the production folder.
     *
     * @param toUpdate the to update
     * @param user the user
     * @throws ValidationException the validation exception
     */
    void approve(NdfUpdateFileVo toUpdate, UserVo user) 
            throws ValidationException;
    
    /**
     * Reject.  Updates the status, moves the file to the reject folder, and remove the associations between the File 
     * and the data.
     *
     * @param toUpdate the to update
     * @param user the user
     * @throws ValueObjectValidationException the value object validation exception
     * @throws ValidationException the validation exception
     */
    void reject(NdfUpdateFileVo toUpdate, UserVo user)
            throws ValueObjectValidationException, ValidationException;   
}
