/**
 * Source file created in 2011 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.service.common.scheduler.tasks;


import org.apache.logging.log4j.Logger; 
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.annotation.Autowired;


import gov.va.med.pharmacy.peps.service.common.capability.StsCapability;


/**
 * 
 * StsTaskImpl
 */
public class StsTaskImpl implements StsTask {

    private static final Logger LOG = org.apache.logging.log4j.LogManager.getLogger(StsTaskImpl.class);
    
    @Autowired
    private StsCapability stsCapability;

    @Override
    public void runStsProcess() {
        
        LOG.debug(".....................Synchronize STS process................ ~");
        
        LOG.debug(".....................Running synchronize STS process................ ~");
        stsCapability.synchronizedFDBUpdate();
    }
    
    
    /**
     * printMe - remove later  
     *
     */
    public void printMe() {
    }


    /**
     * getS Sts Capability
     * @return the stsCapability
     */
    public StsCapability getStsCapability() {
        return stsCapability;
    }


    /**
     * setS the StsCapability
     * @param stsCapability the stsCapability to set
     */
    public void setStsCapability(StsCapability stsCapability) {
        this.stsCapability = stsCapability;
    }
    
}
