package gov.va.med.pharmacy.peps.service.common.scheduler.tasks;

import gov.va.med.pharmacy.peps.common.vo.Role;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.utility.client.rxnorm.RxNormClient;
import gov.va.med.pharmacy.peps.service.common.capability.FdbSchedulerProcessCapability;
import gov.va.med.pharmacy.peps.service.common.capability.RxNormUpdateCapability;

import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;


/**
 * Class defining the method behavior for managing the RxNorm Update job process
 * 
 * @author VHAISHEdgecK
 *
 */
public class RxNormUpdateTaskImpl implements RxNormUpdateTask {
    
    private static final Logger LOG = org.apache.logging.log4j.LogManager.getLogger(RxNormUpdateTaskImpl.class);
    private static final Long USER_ID = 42L;
    private static final String STATION = "999";
    
    @Autowired
    private RxNormUpdateCapability rxNormUpdateCapability;
    
    @Autowired
    private FdbSchedulerProcessCapability fdbSchedulerProcessCapability;

    
    /* (non-Javadoc)
     * @see gov.va.med.pharmacy.peps.service.common.scheduler.tasks.RxNormUpdateTask#runRxNormUpdateProcess()
     */
    @Override
    public void runRxNormUpdateProcess() {
        LOG.debug(".....................synchronize RXNORM UPDATE process................ ~");        
        rxNormUpdateCapability.process(getUser());
    }

    /**
     * getUser
     * @return UserVo
     */
    private UserVo getUser() {

        UserVo user = new UserVo();
        user.setFirstName("RXNORMUpdate");
        user.setLastName("UpdateFileProcess");
        user.setStationNumber(STATION);
        user.setUsername("RxNormUpdateProcess");
        user.setLocation("NationalSite");
        user.setId(USER_ID);
        user.addRole(Role.PSS_PPSN_MANAGER );

        return user;

    }    
   
    
    /**
     * Gets the rxNormUpdateCapability.
     * @return the rxNormUpdateCapability
     */
    public RxNormUpdateCapability getRxNormUpdateCapability() {
        return rxNormUpdateCapability;
    }
    
    /**
     * Sets the rxNormUpdateCapability.
     * @param rxNormUpdateCapability the rxNormUpdateCapability
     */
    public void setRxNormUpdateCapability(RxNormUpdateCapability rxNormUpdateCapability) {
        this.rxNormUpdateCapability = rxNormUpdateCapability;
    }
    
    /**
     * get FdbSchedulerProcessCapability
     * @return the fdbSchedulerProcessCapability
     */
    public FdbSchedulerProcessCapability getFdbSchedulerProcessCapability() {
        return fdbSchedulerProcessCapability;
    }

    /**
     * setFdbSchedulerProcessCapability
     * @param fdbSchedulerProcessCapability the fdbSchedulerProcessCapability to set
     */
    public void setFdbSchedulerProcessCapability(
            FdbSchedulerProcessCapability fdbSchedulerProcessCapability) {
        this.fdbSchedulerProcessCapability = fdbSchedulerProcessCapability;
    }

    
}
