package gov.va.med.pharmacy.peps.service.common.scheduler.tasks;

import gov.va.med.pharmacy.peps.service.common.capability.FdbSchedulerProcessCapability;
import gov.va.med.pharmacy.peps.service.common.capability.NdfUpdateCapability;
import gov.va.med.pharmacy.peps.common.vo.Role;
import gov.va.med.pharmacy.peps.common.vo.UserVo;

import org.apache.logging.log4j.Logger; 
import org.springframework.beans.factory.annotation.Autowired;


/**
 * Scheduled task for NDF Update File Creation.
 *
 */
public class NdfUpdateTaskImpl implements NdfUpdateTask {
    
    private static final Logger LOG = org.apache.logging.log4j.LogManager.getLogger(NdfUpdateTaskImpl.class);
    
    @Autowired
    private NdfUpdateCapability ndfUpdateCapability;
    
    @Autowired
    private FdbSchedulerProcessCapability fdbSchedulerProcessCapability;
    private static final Long USER_ID = 42L;
    private static final String STATION = "999";

    @Override
    public void runNdfUpdateProcess() {
        LOG.debug(".....................synchronize NDF UPDATE process................ ~");        
        
        ndfUpdateCapability.process(getBatchUser());
    }

    /**
     * Get the user to be used by the scheduled job.
     * @return UserVo
     */
    private UserVo getBatchUser() {

        UserVo user = new UserVo();
        user.setFirstName("NDFUpdate");
        user.setLastName("UpdateFileProcess");
        user.setStationNumber(STATION);
        user.setUsername("NdfUpdateProcess");
        user.setLocation("NationalSite");
        user.setId(USER_ID);
        user.addRole(Role.PSS_PPSN_MANAGER );

        return user;

    }    
   
    
    public NdfUpdateCapability getNdfUpdateCapability() {
        return ndfUpdateCapability;
    }

    
    public void setNdfUpdateCapability(NdfUpdateCapability ndfUpdateCapability) {
        this.ndfUpdateCapability = ndfUpdateCapability;
    }
    
    /**
     * Get FdbSchedulerProcessCapability.
     * @return the fdbSchedulerProcessCapability
     */
    public FdbSchedulerProcessCapability getFdbSchedulerProcessCapability() {
        return fdbSchedulerProcessCapability;
    }

    /**
     * Set FdbSchedulerProcessCapability.
     * @param fdbSchedulerProcessCapability the fdbSchedulerProcessCapability to set
     */
    public void setFdbSchedulerProcessCapability(
            FdbSchedulerProcessCapability fdbSchedulerProcessCapability) {
        this.fdbSchedulerProcessCapability = fdbSchedulerProcessCapability;
    }

    
}
