/**
 * Source file created in 2007 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.service.common.scheduler.tasks;


import org.apache.logging.log4j.Logger; 
import org.apache.logging.log4j.LogManager;
import gov.va.med.pharmacy.peps.service.common.capability.ProposedInactivateCapability;




/**
 * InactivationCheckTaskImpl
 * 
 */
public class InactivationCheckTaskImpl implements InactivationCheckTask {

    private static final Logger LOG = LogManager.getLogger(InactivationCheckTaskImpl.class);
    private ProposedInactivateCapability proposedInactivateCapability;

    
    /**
     * runs all fdb processes
     */
    @Override
    public void runInactivationCheckProcess() {
        LOG.debug("..... InactivationCheckProcess .....");
        
        LOG.debug(".... running runInactivationCheckProcess() process .........");
            proposedInactivateCapability.synchronizedProposedInactivationDate();
    }
    
    /**
     * set setProposedInactivateCapability
     * @param proposedInactivateCapability the proposedInactivateCapability to set
     */
    public void setProposedInactivateCapability(
            ProposedInactivateCapability proposedInactivateCapability) {
        this.proposedInactivateCapability = proposedInactivateCapability;
    }
}
