/**
 * Source file created in 2011 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.service.common.scheduler.tasks;



import org.apache.logging.log4j.Logger; 
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.pharmacy.peps.service.common.capability.FssCapability;



/**
 * 
 * FdbFssTaskImpl
 *
 */
public class FssTaskImpl implements FssTask {


    private static final Logger LOG = org.apache.logging.log4j.LogManager.getLogger(FssTaskImpl.class);

    @Autowired
    private FssCapability fssCapability;
    
    
    @Override
    public void printMe() {
    }

    @Override
    public void runFssProcess() {
        LOG.debug(".....................synchronize FSS process................ ");
        
        LOG.debug(".....................Running synchronize FSS process................ ");
        fssCapability.synchronizedFSSUpdate();
    }

    
    /**
     * get getFssCapability
     * @return the fssCapability
     */
    public FssCapability getFssCapability() {
        return fssCapability;
    }



    /**
     * set setFssCapability
     * @param fssCapability the fssCapability to set
     */
    public void setFssCapability(
            FssCapability fssCapability) {
        this.fssCapability = fssCapability;
    }
}
