/**
 * Source file created in 2007 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.service.common.scheduler.tasks;


import org.apache.logging.log4j.Logger; 
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.pharmacy.peps.service.common.capability.AutoAddUpdateCapability;


/**
 * 
 * RunTaskImpl
 */
public class FdbAddTaskImpl implements FdbAddTask {

    private static final Logger LOG = org.apache.logging.log4j.LogManager.getLogger(FdbAddTaskImpl.class);
    
    @Autowired
    private AutoAddUpdateCapability autoAddUpdateCapability;

    @Override
    public void runFdbAddProcess() {
        LOG.debug(".....................Synchronize FDB ADD process................ ");
        
        LOG.debug(".... running FDB ADD process .........");
        autoAddUpdateCapability.synchronizeFdbAdd();
    }
    
    
    /**
     * printMe - remove later  
     *
     */
    public void printMe() {
    }



    /**
     * get AutoAddUpdateCapability
     * @return the autoAddUpdateCapability
     */
    public AutoAddUpdateCapability getAutoAddUpdateCapability() {
        return autoAddUpdateCapability;
    }



    /**
     * set AutoAddUpdateCapability
     * @param autoAddUpdateCapability the autoAddUpdateCapability to set
     */
    public void setAutoAddUpdateCapability(
            AutoAddUpdateCapability autoAddUpdateCapability) {
        this.autoAddUpdateCapability = autoAddUpdateCapability;
    }

}

