package gov.va.med.pharmacy.peps.service.common.scheduler.jobs;

import gov.va.med.pharmacy.peps.service.common.scheduler.tasks.RxNormUpdateTaskImpl;

import java.util.Date;

import org.apache.logging.log4j.Logger;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

/**
 * RxNormUpdate implementation of the QuartzJobBean
 * 
 * @author VHAISHEdgecK
 *
 */
@DisallowConcurrentExecution
public class RxNormUpdateJob extends QuartzJobBean implements Job {
    
    private static final Logger LOG = org.apache.logging.log4j.LogManager.getLogger(RxNormUpdateJob.class);
    
    private RxNormUpdateTaskImpl rxNormUpdateTask;
    
    /**
     * Main execution method 
     * @param context - JobExecutionContext
     * @throws JobExecutionException JobExecutionException
     */
    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        
        LOG.debug("\n");
        LOG.debug("-------------------------- Executing RxNormUpdate Job ------------------------------------");
        LOG.debug(" Time:  " +  new Date() + "                                                         ");
        LOG.debug(" Next fire time: " + context.getNextFireTime() + "                                  ");
        
        rxNormUpdateTask.runRxNormUpdateProcess();
    }

    /**
     * getRxNormUpdateTask
     * @return the rxNormUpdateTask
     */
    public RxNormUpdateTaskImpl getRxNormUpdateTask() {
        return rxNormUpdateTask;
    }


    /**
     * setRxNormUpdateTask
     * @param rxNormUpdateTask the rxNormUpdateTask to set
     */
    public void setRxNormUpdateTask(RxNormUpdateTaskImpl rxNormUpdateTask) {
        this.rxNormUpdateTask = rxNormUpdateTask;
    }

}
