package gov.va.med.pharmacy.peps.service.common.scheduler.jobs;

import gov.va.med.pharmacy.peps.service.common.scheduler.tasks.NdfUpdateTaskImpl;

import java.util.Date;

import org.apache.logging.log4j.Logger; 
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;

/**
 * Quartz Job bean for NDF Update File Creation.
 *
 */
@DisallowConcurrentExecution
public class NdfUpdateJob extends QuartzJobBean implements Job {
    
    /** The logger. */
    private static final Logger LOG = org.apache.logging.log4j.LogManager.getLogger(NdfUpdateJob.class);
    
    /** The ndf update task. */
    private NdfUpdateTaskImpl ndfUpdateTask;
    
    /**
     * Main execution method. 
     * @param context - JobExecutionContext
     * @throws JobExecutionException JobExecutionException
     */
    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        
        LOG.debug("\n");
        LOG.debug("-------------------------- Executing NdfUpdate Job ------------------------------------");
        LOG.debug(" Time:  " +  new Date() + "                                                         ");
        LOG.debug(" Next fire time: " + context.getNextFireTime() + "                                  ");
        
        ndfUpdateTask.runNdfUpdateProcess();
    }

    /**
     * getNdfUpdateTask.
     * @return the ndfUpdateTask
     */
    public NdfUpdateTaskImpl getNdfUpdateTask() {
        return ndfUpdateTask;
    }


    /**
     * setNdfUpdateTask.
     * @param ndfUpdateTask the ndfUpdateTask to set
     */
    public void setNdfUpdateTask(NdfUpdateTaskImpl ndfUpdateTask) {
        this.ndfUpdateTask = ndfUpdateTask;
    }

}
