/**
 * Source file created in 2007 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.service.common.scheduler.jobs;


import gov.va.med.pharmacy.peps.service.common.scheduler.tasks.InactivationCheckTaskImpl;

import java.util.Date;

import org.apache.logging.log4j.Logger; 
import org.apache.logging.log4j.LogManager;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;


/**
 * InactivationCheckJob
 * This Job executes the runInactivationCheckTask
 */
@DisallowConcurrentExecution
public class InactivationCheckJob extends QuartzJobBean implements Job {

    private static final Logger LOG = LogManager.getLogger(InactivationCheckJob.class);
    
    private InactivationCheckTaskImpl inactivationCheckTask;
    
    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {

        
        LOG.debug("\n");
        LOG.debug("-------------------------- Executing InactivationCheckJob JOB ------------------------------------");
        LOG.debug(" Time:  " +  new Date() + "                                                                ");
        LOG.debug(" Next fire time: " + context.getNextFireTime() + "                                         ");
        
        inactivationCheckTask.runInactivationCheckProcess();
        
    }

    /**
     * gets InactivationCheckTask
     * @return the inactivationCheckTask
     */
    public InactivationCheckTaskImpl getInactivationCheckTask() {
        return inactivationCheckTask;
    }

    /**
     * sets InactivationCheckTask
     * @param inactivationCheckTask the inactivationCheckTask to set
     */
    public void setInactivationCheckTask(
            InactivationCheckTaskImpl inactivationCheckTask) {
        this.inactivationCheckTask = inactivationCheckTask;
    }

  


}
