/**
 * Source file created in 2007 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.service.common.scheduler.jobs;




import gov.va.med.pharmacy.peps.service.common.scheduler.tasks.FdbUpdateTaskImpl;

import java.util.Date;

import org.apache.logging.log4j.Logger; 
import org.apache.logging.log4j.LogManager;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.springframework.scheduling.quartz.QuartzJobBean;


/**
 * 
 * FdbUpdateJob
 */
@DisallowConcurrentExecution
public class FdbUpdateJob extends QuartzJobBean implements Job {

    private static final Logger LOG = org.apache.logging.log4j.LogManager.getLogger(FdbUpdateJob.class);
    
    private FdbUpdateTaskImpl fdbUpdateTask;
    
    /**
     * Contructor for QueryFDBJob
     *
     */
    public FdbUpdateJob() {
    }
    
   
    /**
     * Main execution method 
     * @param context - JobExecutionContext
     * @throws JobExecutionException JobExecutionException
     */
    @Override
    protected void executeInternal(JobExecutionContext context) throws JobExecutionException {
        
        LOG.debug("\n");
        LOG.debug("-------------------------- Executing FdbUpdate Job ------------------------------------");
        LOG.debug(" Time:  " +  new Date() + "                                                         ");
        LOG.debug(" Next fire time: " + context.getNextFireTime() + "                                  ");
        
        fdbUpdateTask.runFdbUpdateProcess();
    }




    /**
     * getFdbUpdateTask
     * @return the fdbUpdateTask
     */
    public FdbUpdateTaskImpl getFdbUpdateTask() {
        return fdbUpdateTask;
    }




    /**
     * setFdbUpdateTask
     * @param fdbUpdateTask the fdbUpdateTask to set
     */
    public void setFdbUpdateTask(FdbUpdateTaskImpl fdbUpdateTask) {
        this.fdbUpdateTask = fdbUpdateTask;
    }

    
    
}
