package gov.va.med.pharmacy.peps.service.common.capability.impl;

import java.util.List;

import org.apache.logging.log4j.Logger; 
import org.apache.logging.log4j.LogManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.DefaultTransactionDefinition;

import gov.va.med.pharmacy.peps.common.vo.RematchSuggestionVo;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.capability.RematchSuggestionMgtDomainCapability;
import gov.va.med.pharmacy.peps.service.common.capability.RematchSuggestionCapability;


public class RematchSuggestionCapabilityImpl implements RematchSuggestionCapability{
    
    private static final Logger LOG = LogManager.getLogger(RematchSuggestionCapabilityImpl.class);
    
    @Autowired
    private PlatformTransactionManager transactionManager;
    private RematchSuggestionMgtDomainCapability rematchSuggestionMgtDomainCapability;

    @Override
    public List<RematchSuggestionVo> retrieveAllRematch() {
        return rematchSuggestionMgtDomainCapability.retrieveAll();
        
    }
    
    @Override
    public void removeObsoleteProducts() {
        rematchSuggestionMgtDomainCapability.removeObsoleteProducts();
        
    }
    
    @Override
    public void addUnmatchedProducts(UserVo user) {
        
        rematchSuggestionMgtDomainCapability.addUnmatchedProducts(user);      
        
    }
    
    @Override
    public List<RematchSuggestionVo> retrieveUnmatched(Long matchTypeId){
        return rematchSuggestionMgtDomainCapability.retrieveUnmatched(matchTypeId);
        
    }
    
    @Override
    public Long retrieveProductId(String productIen){
        return rematchSuggestionMgtDomainCapability.retrieveProductId(productIen);
        
    }
    
    @Override   
    public List<Object[]> findRematchProducts(Long productId) {
        return rematchSuggestionMgtDomainCapability.findRematchProducts(productId);
    }  
    
    @Override
    public void updateRematch(Long rematchId, String matchIen, Boolean autoMatch){
        rematchSuggestionMgtDomainCapability.update(rematchId, matchIen, autoMatch);
        
    }
    
    public PlatformTransactionManager getTransactionManager() {
        return transactionManager;
    }

    
    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    
    public RematchSuggestionMgtDomainCapability getRematchSuggestionMgtDomainCapability() {
        return rematchSuggestionMgtDomainCapability;
    }


    
    public void setRematchSuggestionMgtDomainCapability(RematchSuggestionMgtDomainCapability rematchSuggestionMgtDomainCapability) {
        this.rematchSuggestionMgtDomainCapability = rematchSuggestionMgtDomainCapability;
    }
    

}
