package gov.va.med.pharmacy.peps.service.common.capability.impl;

import gov.va.med.pharmacy.peps.common.utility.VistaFileNumber;
import gov.va.med.pharmacy.peps.domain.common.capability.ProductDomainCapability;
import gov.va.med.pharmacy.peps.domain.common.dao.EplNdfOutgoingDifferencesDao;
import gov.va.med.pharmacy.peps.domain.common.dao.EplRematchSuggestionDao;
import gov.va.med.pharmacy.peps.external.common.utility.MumpsConverter;
import gov.va.med.pharmacy.peps.service.common.utility.NdfUpdateProcessFile;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

import static gov.va.med.pharmacy.peps.common.utility.ESAPIValidationType.LOG_FORGING;
import static gov.va.med.pharmacy.peps.common.utility.ESAPIValidator.validateStringInput;

public class NdfUpdateProcessMiscData {
    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager
        .getLogger(NdfUpdateProcessCapabilityImpl.class);
    
    public ProductDomainCapability productDomainCapability;
    public EplNdfOutgoingDifferencesDao eplNdfOutgoingDifferencesDao; 
    public EplRematchSuggestionDao eplRematchSuggestionDao;
    
    final String newLine = System.getProperty("line.separator");
    
    //REM - local re-match suggestion
    public void rematchProducts(Date startDTM, NdfUpdateProcessFile ndfUpdateFile) throws IOException{
        List<Object[]> rematchProducts = eplRematchSuggestionDao.findRematchAuto(startDTM);
        List<Object[]> rematchInactiveProducts = eplNdfOutgoingDifferencesDao.findInactiveRematchReport(VistaFileNumber.FIFTY_68.getFileNumber(), "21", startDTM);
        if(rematchProducts != null && !rematchProducts.isEmpty()){
            for (Object[] rematchProduct : rematchProducts) {
                
                try {
                    ndfUpdateFile.putNextRow("REM^" + rematchProduct[0]);
                    ndfUpdateFile.putNextRow((String)rematchProduct[1]);
                } catch (IOException e) {
                  LOG.error("error processing row for inactive products with ien of " + validateStringInput(rematchProduct[0].toString(), LOG_FORGING));
                  throw e;
                }
            }            
        }
        
        if(rematchInactiveProducts != null && !rematchInactiveProducts.isEmpty()){
            for (Object[] rematchInactiveProduct : rematchInactiveProducts) {
                
                try {
                    ndfUpdateFile.putNextRow("REM^" + rematchInactiveProduct[0]);
                    ndfUpdateFile.putNextRow((String)rematchInactiveProduct[5]);
                } catch (IOException e) {
                  LOG.error("error processing row for inactive products with ien of " + validateStringInput(rematchInactiveProduct[0].toString(), LOG_FORGING));
                  throw e;
                }
            }            
        }
    }

    //5000.68 data inactive product list
    public void inactiveProducts(Date startDTM, NdfUpdateProcessFile ndfUpdateFile) throws IOException{
        List<Object[]> inactiveProducts = productDomainCapability.retrieveInactive();
        List<Object[]> inactivatedProducts = 
            eplNdfOutgoingDifferencesDao.findInactivatedProductsForLocal(VistaFileNumber.FIFTY_68.getFileNumber(), startDTM);
        for (Object[] inactiveProduct : inactiveProducts) {
                
            try {
                ndfUpdateFile.putNextRow("PRODUCT^" + inactiveProduct[0]);
                ndfUpdateFile.putNextRow(" ");
            } catch (IOException e) {
              LOG.error("error processing row for inactive products with ien of " + validateStringInput(inactiveProduct[0].toString(), LOG_FORGING));
              throw e;
            }
        }
        
        for (Object[] inactivatedProduct : inactivatedProducts) {
            
            try {
                ndfUpdateFile.putNextRow("PRODUCT^" + inactivatedProduct[0]);
                ndfUpdateFile.putNextRow(" ");
            } catch (IOException e) {
              LOG.error("error processing row for unmatched products with ien of " + validateStringInput(inactivatedProduct[0].toString(), LOG_FORGING));
              throw e;
            }
        }
    }
    
    //5000.3 data inactive generic name list
    public void inactiveGenericName(Date startDTM, NdfUpdateProcessFile ndfUpdateFile) throws IOException {
        List<String> inactiveGenericNames = 
            eplNdfOutgoingDifferencesDao.findInactiveGenericName(VistaFileNumber.FIFTY_6.getFileNumber(),"1", startDTM);
        for (String ien : inactiveGenericNames) {            
            try {                
                ndfUpdateFile.putNextRow("GENERIC^" + ien);
                ndfUpdateFile.putNextRow(" ");
            } catch (IOException e) {
              LOG.error("error processing row for inactive generic name with ien of " + validateStringInput(ien, LOG_FORGING));
              throw e;
            }
    
        }
    }
    
    //5000.4 Strength Change data list
    public void productStrengthChanges(Date startDTM, NdfUpdateProcessFile ndfUpdateFile) throws IOException{
        List<Object[]> productStrengthChanges = 
            eplNdfOutgoingDifferencesDao.findByFileAndField(VistaFileNumber.FIFTY_68.getFileNumber(),"17", startDTM );
        for (Object[] productStrengthIen : productStrengthChanges){
             try {
                ndfUpdateFile.putNextRow("POE^" + productStrengthIen[0]);
                ndfUpdateFile.putNextRow(" ");
            } catch (IOException e) {
              LOG.error("error processing row for strength changes for product ien " + validateStringInput(productStrengthIen[0].toString(), LOG_FORGING));
              throw e;
            }
        }
    }
    
    //5000.5 National Formulary data list
    public void productFormularyChanges(Date startDTM, NdfUpdateProcessFile ndfUpdateFile) throws IOException{
        List<Object[]> productFormularyChanges = 
            eplNdfOutgoingDifferencesDao.findByFileAndField(VistaFileNumber.FIFTY_68.getFileNumber(),"2", startDTM );
        for (Object[] productFormularyIen : productFormularyChanges){
             try {
                ndfUpdateFile.putNextRow("NFI^" + productFormularyIen[0]);
                ndfUpdateFile.putNextRow(" ");
            } catch (IOException e) {
              LOG.error("error processing row for formulary changes for product ien " + validateStringInput(productFormularyIen[0].toString(), LOG_FORGING));
              throw e;
            }
        }
    }
    
    //5000.6 Drug Class change
    public void productDrugClassChanges(Date startDTM, NdfUpdateProcessFile ndfUpdateFile) throws IOException{
        List<Object[]> productDrugClassChanges = 
            eplNdfOutgoingDifferencesDao.findDrugClassChanges(VistaFileNumber.FIFTY_68.getFileNumber(),"15", startDTM );
        for (Object[] productDrugClassData : productDrugClassChanges){
            try {
                 ndfUpdateFile.putNextRow("CLASS^" + productDrugClassData[0] + "^0");
                 ndfUpdateFile.putNextRow(productDrugClassData[0] + "^" + productDrugClassData[1] + "^" + productDrugClassData[2] ); 
           } catch (IOException e) {
                LOG.error("error processing row for drug class changes for product ien " + validateStringInput(productDrugClassData[0].toString(), LOG_FORGING));
                throw e;
            }
        }
    }
    
    
    //5000.7 Unmark for CMOP
    public void productUnmarkForCmopChanges(Date startDTM, NdfUpdateProcessFile ndfUpdateFile) throws IOException{
        List<Object[]> productUnmarkForCmopChanges = 
            eplNdfOutgoingDifferencesDao.findByFileAndField(VistaFileNumber.FIFTY_68.getFileNumber(),"7", startDTM );
        for (Object[] productCmopIen : productUnmarkForCmopChanges){
            if(productCmopIen[1].equals("0")){ 
                try {
                    ndfUpdateFile.putNextRow("CMOP^" + productCmopIen[0]);
                    ndfUpdateFile.putNextRow(" ");
                } catch (IOException e) {
                  LOG.error("error processing row for cmop indicator changes for product ien " + validateStringInput(productCmopIen[0].toString(), LOG_FORGING));
                  throw e;
                }
            }
        }
    }       
    
    /**
     * @return the productDomainCapability
     */
    public ProductDomainCapability getProductDomainCapability() {
        return productDomainCapability;
    }
   
    /**
     * @param productDomainCapability the productDomainCapability to set
     */
    public void setProductDomainCapability(ProductDomainCapability productDomainCapability) {
        this.productDomainCapability = productDomainCapability;
    }
    
    /**
     * @return the eplNdfOutgoingDifferencesDao
     */
    public EplNdfOutgoingDifferencesDao getEplNdfOutgoingDifferencesDao() {
        return eplNdfOutgoingDifferencesDao;
    }
    
    /**
     * @param eplNdfOutgoingDifferencesDao the eplNdfOutgoingDifferencesDao to set
     */
    public void setEplNdfOutgoingDifferencesDao(EplNdfOutgoingDifferencesDao eplNdfOutgoingDifferencesDao) {
        this.eplNdfOutgoingDifferencesDao = eplNdfOutgoingDifferencesDao;
    }

    
    public EplRematchSuggestionDao getEplRematchSuggestionDao() {
        return eplRematchSuggestionDao;
    }

    
    public void setEplRematchSuggestionDao(EplRematchSuggestionDao eplRematchSuggestionDao) {
        this.eplRematchSuggestionDao = eplRematchSuggestionDao;
    }
}