package gov.va.med.pharmacy.peps.service.common.capability.impl;

import firstdatabank.database.FDBDataManager;
import gov.va.med.pharmacy.peps.common.utility.ConfigFileUtility;
import gov.va.med.pharmacy.peps.common.vo.FdbGcnseqnoPemVVo;
import gov.va.med.pharmacy.peps.common.vo.FdbGcnseqnoPlblwVVo;
import gov.va.med.pharmacy.peps.common.vo.FdbMonographPemVVo;
import gov.va.med.pharmacy.peps.common.vo.NationalSetting;
import gov.va.med.pharmacy.peps.common.vo.NationalSettingVo;
import gov.va.med.pharmacy.peps.common.vo.NdfUpdateFileVo;
import gov.va.med.pharmacy.peps.domain.common.capability.NationalSettingDomainCapability;
import gov.va.med.pharmacy.peps.domain.common.capability.ProductDomainCapability;
import gov.va.med.pharmacy.peps.domain.common.dao.EplNdfOutgoingDifferencesDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;
import gov.va.med.pharmacy.peps.domain.common.utility.FdbGcnseqnoPemVDomainCapability;
import gov.va.med.pharmacy.peps.domain.common.utility.FdbGcnseqnoPlblwVDomainCapability;
import gov.va.med.pharmacy.peps.domain.common.utility.FdbMonographPemVDomainCapability;
import gov.va.med.pharmacy.peps.domain.common.utility.FdbPlblwarningsVDomainCapability;
import gov.va.med.pharmacy.peps.external.common.drugdatavendor.outbound.utility.JdbcConnectionFactory;
import gov.va.med.pharmacy.peps.service.common.capability.MessageDataCapability;
import gov.va.med.pharmacy.peps.service.common.capability.NdfUpdateProcessCapability;
import gov.va.med.pharmacy.peps.service.common.capability.WordProcessingFieldHelper;
import gov.va.med.pharmacy.peps.service.common.utility.NdfUpdateMonographPemMapping;
import gov.va.med.pharmacy.peps.service.common.utility.NdfUpdateNdfDataMapping;
import gov.va.med.pharmacy.peps.service.common.utility.NdfUpdatePlblwarningsMapping;
import gov.va.med.pharmacy.peps.service.common.utility.NdfUpdateProcessFile;
import gov.va.med.pharmacy.peps.service.common.utility.NdfUpdateVaProductAssociationsMapping;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Hashtable;
import java.util.List;

import javax.annotation.Resource;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

import org.hibernate.ScrollableResults;
import org.springframework.beans.factory.annotation.Required;

/**
 * FdbUpdateProcessCapabilityImpl.
 */
public class NdfUpdateProcessCapabilityImpl implements NdfUpdateProcessCapability {

    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager
        .getLogger(NdfUpdateProcessCapabilityImpl.class);
    
    private FdbMonographPemVDomainCapability fdbMonographPemVDomainCapability;
    private FdbPlblwarningsVDomainCapability fdbPlblwarningsVDomainCapability;
    private FdbGcnseqnoPemVDomainCapability fdbGcnseqnoPemVDomainCapability;
    private FdbGcnseqnoPlblwVDomainCapability fdbGcnseqnoPlblwVDomainCapability;
    private ProductDomainCapability productDomainCapability;
    private EplNdfOutgoingDifferencesDao eplNdfOutgoingDifferencesDao; 
    private NationalSettingDomainCapability nationalSettingDomainCapability;
    private NdfUpdateMonographPemMapping ndfUpdateMonographPemMapping;
    private NdfUpdatePlblwarningsMapping ndfUpdatePlblwarningsMapping;
    private NdfUpdateVaProductAssociationsMapping ndfUpdateVaProductAssociationsMapping;
    private NdfUpdateNdfDataMapping ndfUpdateNdfDataMapping;
    private NdfUpdateProcessMiscData ndfUpdateProcessMiscData;
    private MessageDataCapability messageDataCapability;
    @Resource
    private WordProcessingFieldHelper wordProcessingFieldHelper;
    
    private long[] languageTypes = new long[] { 1, 2 };
    private Long maxMonographId;
    private static final long english = 1;
    private static final String PARENT = ".01";
    private static final String CHILD = ",.01";
    private List<EplNdfOutgoingDifferences> returnedOutgoingDifferences = null;
    
    @Override
    public void processNdfData(Date startDate, NdfUpdateProcessFile ndfUpdateFile) throws IOException {
        String vistaFileNumber;
        String vistaFieldNumber;
        
        LOG.info("---------------writing ndf data-------------------");
        try {
            setNdfUpdateNdfDataMapping(new NdfUpdateNdfDataMapping());
                returnedOutgoingDifferences = eplNdfOutgoingDifferencesDao.retrieveDifferencesForOutputFile(startDate);
            
            LOG.info("ndf row count = "+ returnedOutgoingDifferences.size() + " for startDate " + startDate);
            for (int i = 0; i < returnedOutgoingDifferences.size(); i++) {
                int count = 0;
                String txnType = " ";
                if (returnedOutgoingDifferences.get(i).getVistaFieldNumber().endsWith(PARENT) 
                    && !returnedOutgoingDifferences.get(i).getNewValue().equals(" ") ) { 
                    txnType = 
                    returnedOutgoingDifferences.get(i).getVistaFieldNumber().length() == 3 ?PARENT : CHILD;
                }

                switch (txnType) {
                    case PARENT:
                        count = 1;

                        ndfUpdateFile.putNextRow(ndfUpdateNdfDataMapping.
                            formatHeaderRowForDATANT(returnedOutgoingDifferences.get(i).getVistaFileNumber(), count));
                        ndfUpdateFile.putNextRow(ndfUpdateNdfDataMapping.
                            formatIenRowForDATANT(returnedOutgoingDifferences.get(i)));
                        ndfUpdateFile.putNextRow(ndfUpdateNdfDataMapping.
                            formatHeaderRowForDATANT(returnedOutgoingDifferences.get(i).getVistaFileNumber(), count + 1));
                        ndfUpdateFile.putNextRow(returnedOutgoingDifferences.get(i).getNewValue());
                        break;
                    case CHILD:
                        count = 1;
                        
                        vistaFileNumber = returnedOutgoingDifferences.get(i).getVistaFileNumber();
                        vistaFieldNumber = returnedOutgoingDifferences.get(i).getVistaFieldNumber();
                        
                        if ( wordProcessingFieldHelper.isWordProcessingField(vistaFileNumber,  vistaFieldNumber))
                        {
                        	wordProcessingFieldHelper.formatWordProcessingField(ndfUpdateFile, returnedOutgoingDifferences.get(i), vistaFileNumber, vistaFieldNumber);
                        } else {
	                        ndfUpdateFile.putNextRow(ndfUpdateNdfDataMapping.
	                            formatHeaderRowForDATAN(returnedOutgoingDifferences.get(i).getVistaFileNumber(), count));
	                        ndfUpdateFile.putNextRow(ndfUpdateNdfDataMapping.
	                            formatIenRowForDATAN(returnedOutgoingDifferences.get(i)));
	                        ndfUpdateFile.putNextRow(ndfUpdateNdfDataMapping.
	                            formatHeaderRowForDATAN(returnedOutgoingDifferences.get(i).getVistaFileNumber(), count + 1));
	                        ndfUpdateFile.putNextRow(returnedOutgoingDifferences.get(i).getNewValue());
                        }
                        break;

                    default:
                        count = 1;

                        vistaFileNumber = returnedOutgoingDifferences.get(i).getVistaFileNumber();
                        vistaFieldNumber = returnedOutgoingDifferences.get(i).getVistaFieldNumber();
                        
                        if ( wordProcessingFieldHelper.isWordProcessingField(vistaFileNumber,  vistaFieldNumber))
                        {
                        	wordProcessingFieldHelper.formatWordProcessingField(ndfUpdateFile, returnedOutgoingDifferences.get(i), vistaFileNumber, vistaFieldNumber);
                        } else {
	                        ndfUpdateFile.putNextRow(ndfUpdateNdfDataMapping.
	                            formatHeaderRowForDATAO(returnedOutgoingDifferences.get(i).getVistaFileNumber(), count));
	                        ndfUpdateFile.putNextRow(ndfUpdateNdfDataMapping.
	                            formatIenRowForDATAO(returnedOutgoingDifferences.get(i)));
	                        ndfUpdateFile.putNextRow(ndfUpdateNdfDataMapping.
	                            formatHeaderRowForDATAO(returnedOutgoingDifferences.get(i).getVistaFileNumber(), count + 1));
	                        if(returnedOutgoingDifferences.get(i).getNewValue().equals(" "))
	                        {
	                            ndfUpdateFile.putNextRow("");
	                        }else{
	                            ndfUpdateFile.putNextRow(returnedOutgoingDifferences.get(i).getNewValue());
	                        }
                        }
                        break;
                }
            }
        } catch (IOException e) {
            LOG.error("Exception in NdfUpdateProcessCapabilityImpl.processNdfData()  " + e.getMessage());
        }
    }
    
    
    /**
    * process Misc NDF data reports
    *
    * @param NdfUpdateProcessFile
    *           ndfupdatefile
     * @throws IOException 
    */

    public void processMiscellaneousNdfDataItems(Date startDTM, NdfUpdateProcessFile ndfUpdateFile) throws IOException {
        
        LOG.info("---------------writing misc ndf data-------------------");
       
        //5000.68 data inactive product list
        ndfUpdateProcessMiscData.inactiveProducts(startDTM, ndfUpdateFile);
        
        //5000.3 data inactive generic name list
        ndfUpdateProcessMiscData.inactiveGenericName(startDTM, ndfUpdateFile);
        
        //5000.4 Strength Changes report
        ndfUpdateProcessMiscData.productStrengthChanges(startDTM, ndfUpdateFile);
        
        //5000.5 National Formulary changes report
        ndfUpdateProcessMiscData.productFormularyChanges(startDTM, ndfUpdateFile);
        
        //5000.6 Drug Class changes report
        ndfUpdateProcessMiscData.productDrugClassChanges(startDTM, ndfUpdateFile);
        
        //REM
        ndfUpdateProcessMiscData.rematchProducts(startDTM, ndfUpdateFile);
        
        //5000.7 Unmark for CMOP changes report
        ndfUpdateProcessMiscData.productUnmarkForCmopChanges(startDTM, ndfUpdateFile); 
        
        //message data report
        messageDataCapability.messageReportData(startDTM, ndfUpdateFile);
        
        //message2 data report
        messageDataCapability.message2ReportData(startDTM, ndfUpdateFile);
    }

    /**
    * process VA Product data.
    *
    * @param NdfUpdateProcessFile
    *           ndfupdatefile
    * @return 
     * @throws IOException 
    */
    @Override
    public void processVaProcuctMapData(NdfUpdateProcessFile ndfUpdateFile) throws IOException {
        LOG.info("---------------writing va product data-------------------");

        setNdfUpdateVaProductAssociationsMapping(new NdfUpdateVaProductAssociationsMapping());
        List<Object[]> returnedProducts = productDomainCapability.retrieveGcnNdcMap();
        LOG.info(" product count = " + returnedProducts.size());
        StringBuffer writerBuffer = new StringBuffer(200);
        StringBuffer dataBuffer = new StringBuffer(200);
        int lineCount = 1;

        for (Object[] product : returnedProducts) {
            BigDecimal productIen = (BigDecimal) product[0];
            BigDecimal gcn = (BigDecimal) product[1];
            String ndc = (String) product[2];
            String productNdc = (ndc == null ? "": ndc);

            dataBuffer.append(ndfUpdateVaProductAssociationsMapping.formatTextDataRow(productIen.longValue(), 
                gcn.longValue(), productNdc));
            if ((writerBuffer.length() + dataBuffer.length()) < 180) {
                writerBuffer.append(dataBuffer);
                dataBuffer.setLength(0);
            } else {
                writerBuffer.append(dataBuffer);
                dataBuffer.setLength(0);
                try {
                    ndfUpdateFile.putNextRow(ndfUpdateVaProductAssociationsMapping.formatTextTempRow(lineCount));
                    ndfUpdateFile.putNextRow(writerBuffer.toString());
                    lineCount++;
                    writerBuffer.setLength(0);
                    dataBuffer.setLength(0);
                } catch (IOException e) {
                    LOG.error("Exception in NdfUpdateProcessCapabilityImpl.processVaProductMapData()  " + e.getMessage());                   
                }
            }
        }
        if(writerBuffer.length() != 0){
            try{
                ndfUpdateFile.putNextRow(ndfUpdateVaProductAssociationsMapping.formatTextTempRow(lineCount));
                ndfUpdateFile.putNextRow(writerBuffer.toString());
            } catch (IOException e) {
                LOG.error("Exception in NdfUpdateProcessCapabilityImpl.processVaProductMapData()  " + e.getMessage());
            }
        }
    }

    /**
    * process PMI data.
    *
    * @param NdfUpdateProcessFile
    *           ndfupdatefile
    * @return 
     * @throws IOException 
    */
    public void processPemData(NdfUpdateProcessFile ndfUpdateFile) throws IOException {

        LOG.info("---------------writing PMI data-------------------");
        setNdfUpdateMonographPemMapping(new NdfUpdateMonographPemMapping());

        //process English and Spanish monographs 50.621 50.622
        for (long language : languageTypes) {

            ndfUpdateMonographPemMapping.setPemOutputLanguageType(language);
            setMaxMonographId(fdbMonographPemVDomainCapability.retrieveMaxMonographidByLanguageid(language));
            Long monographCount = fdbMonographPemVDomainCapability.retrieveMonographCountByLanguageid(language);
            try {
                ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.
                    formatTempRowForHeader());

                ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.
                    formatDataRowForPmiHeader(getMaxMonographId(), monographCount));

                if (language == english) {
                    ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.
                        formatPmiRowForPmiTimeStamp());

                    ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.formatDataRowForPmiDateStamp());
                }
            } catch (IOException e) {
                LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processPemData()" + e.getMessage(), e);
            }

            processMonographLines(language, ndfUpdateFile);

            //title monograph map 
            List<FdbMonographPemVVo> returnedTitles =
                fdbMonographPemVDomainCapability.retreiveMonographTitlesBylanguageid(language);
            for (int i = 0; i < returnedTitles.size(); i++) {
                try {
                    ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.formatRowForMonographTitleGcn(returnedTitles.get(i)));
                    ndfUpdateFile.putNextRow(" ");
                } catch (IOException e) {
                    LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processPemData()" + e.getMessage(), e);
                 }
            }
            returnedTitles = null;
        }

        //-----Begin MAP output-----
        //gcn,monographid map English 50.623 and Spanish 50.624
        LOG.info("-------monograph gcn map-----");
        for (long language : languageTypes) {

            ndfUpdateMonographPemMapping.setPemOutputLanguageType(language);
            List<FdbGcnseqnoPemVVo> returnedGcnMap = fdbGcnseqnoPemVDomainCapability.retreiveGcnsMonographids(language);
            setMaxMonographId(fdbMonographPemVDomainCapability.retrieveMaxMonographidByLanguageid(language));

            try {
                ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.formatPmiRowForMapHeader());
                ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.formatDataRowForMapHeader(getMaxMonographId(),
                    returnedGcnMap.size()));
            } catch (IOException e) {
                LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processPemData()" + e.getMessage(), e);
            }

            int mapRowCount = 1;
            for (int i = 0; i < returnedGcnMap.size(); i++) {
                try {
                    ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.formatPmiRowForGcnMonographMap(mapRowCount));
                    ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.formatDataRowForGcnMonographMap(
                        returnedGcnMap.get(i).getGcnSeqNo(), returnedGcnMap.get(i).getMonographId()));
                    mapRowCount++;
                } catch (IOException e) {
                    LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processPemData()" + e.getMessage(), e);
                 }
            }

            Long maxGcn = fdbGcnseqnoPemVDomainCapability.retrieveMaxGcn(language);
            Long totalGcns = fdbGcnseqnoPemVDomainCapability.retrieveGcnCount(language);

            //gcn count map English 50.623           
            LOG.info("-------gcn count-----");
            try {
                ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.formatHeaderMonographIdCountRow(maxGcn,
                    Long.valueOf(totalGcns)));
                ndfUpdateFile.putNextRow(" ");
            } catch (IOException e) {
                LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processPemData()" + e.getMessage(), e);
            }
            for (int i = 0; i < returnedGcnMap.size(); i++) {
                int gcnCount = i + 1;
                try {
                    ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.formatMonographIdCountRow(returnedGcnMap.get(i)
                        .getGcnSeqNo(), gcnCount));
                    ndfUpdateFile.putNextRow(" ");
                } catch (IOException e) {
                    LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processPemData()" + e.getMessage(), e);
                 }
            }
            returnedGcnMap = null;
        }
    }

    /**
     * process PMI data.
     * @return 
     * @throws IOException 
     */
    public void processWarningLabelData(NdfUpdateProcessFile ndfUpdateFile) throws IOException {

        LOG.info("---------------writing warning label data-------------------");
        setNdfUpdatePlblwarningsMapping(new NdfUpdatePlblwarningsMapping());

        //process English warning labels 50.625 and 50.626
        for (long language : languageTypes) {

            ndfUpdatePlblwarningsMapping.setPlblWOutputLanguageType(language);

            Long warningLabelCount = fdbPlblwarningsVDomainCapability.retrieveWarningLabelCount(language);
            String maxLwid = fdbPlblwarningsVDomainCapability.retrieveMaxLwid(language);
            try {
                ndfUpdateFile.putNextRow(ndfUpdatePlblwarningsMapping.formatTempRowForHeader());
                ndfUpdateFile.putNextRow(ndfUpdatePlblwarningsMapping.formatDataRowForHeader(Integer.valueOf(maxLwid), 
                    warningLabelCount));
            } catch (IOException e) {
                LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processWarningLabelData()" + e.getMessage(), e);
             }

            writeWarningLabelById(language, ndfUpdateFile);

            //plblw id count map  50.625 and 50.626
            List<String> plblwIdList = fdbGcnseqnoPlblwVDomainCapability.retreiveLwIdMapByLanguageId(language);
            for (int i = 0; i < plblwIdList.size(); i++) {
                int plblListCount = i + 1;
                try {
                    ndfUpdateFile.putNextRow(ndfUpdatePlblwarningsMapping.formatLwidMapRow(plblwIdList.get(i), plblListCount));
                    ndfUpdateFile.putNextRow(" ");
                } catch (IOException e) {
                    LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processWarningLabelData()" + e.getMessage(), e);
                }
            }
            plblwIdList = null;
        }

        //---Begin Map data--------
        //map gcn, lwid, priority 50.627
        List<FdbGcnseqnoPlblwVVo> gcnLwidPriorityList = fdbGcnseqnoPlblwVDomainCapability.retreiveGcnLwIdAndPriorityMap();
        int gcnMapCount = gcnLwidPriorityList.size();
        try {
            ndfUpdateFile.putNextRow(ndfUpdatePlblwarningsMapping.formatPmiRowForMap());
            ndfUpdateFile.putNextRow(ndfUpdatePlblwarningsMapping.formatDataRowForMapHeader(gcnMapCount, gcnMapCount)); 
        } catch (IOException e) {
            LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processWarningLabelData()" + e.getMessage(), e);
        }
        int lwidMapCount = 1;
        for (int i = 0; i < gcnLwidPriorityList.size(); i++) {
            try {
                ndfUpdateFile.putNextRow(ndfUpdatePlblwarningsMapping.formatPmiRowForMapData(lwidMapCount));
                ndfUpdateFile.putNextRow(ndfUpdatePlblwarningsMapping.formatDataRowForMapData(
                    gcnLwidPriorityList.get(i).getGcnSeqNo(), gcnLwidPriorityList.get(i).getLwId(), gcnLwidPriorityList.get(i)
                        .getPriority()));
                lwidMapCount++;
            } catch (IOException e) {
                LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processWarningLabelData()" + e.getMessage(), e);
            }
        }
        gcnLwidPriorityList = null;

        // plblwid count map for all 50.627
        List<Long> plblwIdList = fdbGcnseqnoPlblwVDomainCapability.retreiveAllGcnsMap();
        for (int i = 0; i < plblwIdList.size(); i++) {
            int gcnCount = i + 1;
            try {
                ndfUpdateFile.putNextRow(ndfUpdatePlblwarningsMapping.formatAllGcnsMapRow(plblwIdList.get(i), gcnCount));
                ndfUpdateFile.putNextRow(" ");
            } catch (IOException e) {
                LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processWarningLabelData()" + e.getMessage(), e);
            }
        }
        plblwIdList = null;
    }

    private void processMonographLines(Long languageId, NdfUpdateProcessFile ndfUpdateFile) throws IOException {

        ScrollableResults returnedMonographs = fdbMonographPemVDomainCapability.retreiveMonographidsBylanguageid(languageId);
        
        String previousSectionCode = "";
        int sectionCount = 1;
        while (returnedMonographs.next()) {
            BigDecimal monographId = (BigDecimal) returnedMonographs.get(0);
            String sectionCode = (String) returnedMonographs.get(1);
            String lineOfText = (String) returnedMonographs.get(2);
            BigDecimal lineOfTextCount = (BigDecimal) returnedMonographs.get(3);

            if (!"A".equals(sectionCode)) {
                if (!previousSectionCode.equals(sectionCode))
                {
                    sectionCount = 1;
                    try {
                        if (NdfUpdateMonographPemMapping.TITLE_INDICATOR.equals(sectionCode)) {
                            ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.formatPmiRowForTitleDateStamp(
                                monographId.longValue()));
                        } else {
                            ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.
                                formatPmiRowForTextDateStamp(monographId.longValue(), sectionCode));
                            ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.
                                formatDataRowForTextDateStamp(lineOfTextCount.longValue()));
                        }
                    } catch (IOException e) {
                        LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processMonographLines()" + e.getMessage(), e);
                     }
                }
                writeMonographLines(monographId.longValue(), sectionCode, lineOfText, sectionCount, ndfUpdateFile);
                if (NdfUpdateMonographPemMapping.TITLE_INDICATOR.equals(sectionCode)) {
                    try {
                        ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.formatPmiRowForTextDateStamp(
                            monographId.longValue(), NdfUpdateMonographPemMapping.BLANK_INDICATOR));

                        ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.formatDataRowForTextDateStamp(1));

                        ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.formatPmiRowForText(
                            monographId.longValue(), NdfUpdateMonographPemMapping.BLANK_INDICATOR, 1));

                        ndfUpdateFile.putNextRow(" ");
                    } catch (IOException e) {
                        LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processMonographLines()" + e.getMessage(), e);
                    }
                }
                sectionCount++;
                previousSectionCode = sectionCode;
            }
        }
        returnedMonographs = null;
    }

    /**
     * process default TEXT data.
     * @return 
     * @throws IOException 
     */
    public void processTextItems(NdfUpdateProcessFile ndfUpdateFile) throws IOException {
        
        NationalSettingVo returnedNationalSetting = 
            nationalSettingDomainCapability.retrieve(NationalSetting.NDF_OUTGOING_FILE_TEXT.toString());
       
        String defaultText = 
            returnedNationalSetting.getStringValue() != null?returnedNationalSetting.getStringValue():"missing text";
         
        String[] splits = defaultText.split("\\|");
        int lineCount = 1;
        for(String text: splits){
            try {
                ndfUpdateFile.putNextRow("TEXT^"+ lineCount);
                ndfUpdateFile.putNextRow(text);
            } catch (IOException e) {
               LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processTextItems()" + e.getMessage(), e);
             }
            lineCount++;

        }
        try {
            ndfUpdateFile.putNextRow("TEXT^"+ lineCount);
            ndfUpdateFile.putNextRow(" ");
            ndfUpdateFile.putNextRow("TREC^1");
            ndfUpdateFile.putNextRow("2");
        } catch (IOException e) {
            LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.processTextItems()" + e.getMessage(), e);
        }

    }

    /**
     * Writes monograph section. Not all sections are available for all
     * language translations.
     * 
     * @param ndfUpdateMonographPemList
     *            list of NdfUpdateMonographPemVo's
     * @param ndfUpdateFile
     *           ndfUpdateFile
     * @throws IOException 
     */
    private void writeMonographLines(Long monographId, String sectionCode, String lineOfText, int sectionCount,  
        NdfUpdateProcessFile ndfUpdateFile) throws IOException   {

        try {
            if (!NdfUpdateMonographPemMapping.TITLE_INDICATOR.equals(sectionCode))
            {
                ndfUpdateFile.putNextRow(ndfUpdateMonographPemMapping.formatPmiRowForText(monographId, sectionCode,sectionCount));
            }
            ndfUpdateFile.putNextRow(lineOfText.trim());
        } catch (IOException e) {
            LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.writeMonographLines()" + e.getMessage(), e);
        }
    }

    /**
     * Writes warning label text.
     * 
     * @param ndfUpdatePlblList
     *             List of FdbPlblwarningsVVo's
     * @param ndfUpdateFile
     *           ndfUpdateFile
     * @throws IOException 
     */
    private void writeWarningLabelById(Long language, NdfUpdateProcessFile ndfUpdateFile) throws IOException {

        String previousId = "";
        int lineCount = 0;

        List<Object[]> ndfUpdatePlblList = fdbPlblwarningsVDomainCapability.retreiveWarningLabelByLanguageId(language);
       
        try {
            int count = 0;
            for (int i = 0; i < ndfUpdatePlblList.size(); i++)
            {
                String lwid = (String) ndfUpdatePlblList.get(i)[0];
                String warningText = (String) ndfUpdatePlblList.get(i)[1];
                BigDecimal totalTextLines = (BigDecimal) ndfUpdatePlblList.get(i)[2];
                if (!previousId.equals(lwid)) {
                    lineCount = 0;
                    count = count + 1;
                    ndfUpdateFile.putNextRow(ndfUpdatePlblwarningsMapping.formatHeaderRowForLwid(count));
                    ndfUpdateFile.putNextRow(lwid);
                    ndfUpdateFile.putNextRow(ndfUpdatePlblwarningsMapping.formatHeaderRowForDateStamp(lwid));
                    ndfUpdateFile.putNextRow(ndfUpdatePlblwarningsMapping.formatDataRowForDateStamp(totalTextLines.intValue()));
                }
                lineCount++;
                previousId = lwid;
                ndfUpdateFile.putNextRow(ndfUpdatePlblwarningsMapping.formatHeaderRowForText(lwid, lineCount));
                ndfUpdateFile.putNextRow(warningText.trim());
            }
        } catch (IOException e) {
            LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.writeWarningLabelById()" + e.getMessage(), e);
        }
        ndfUpdatePlblList = null;
    }
    
    /**
     * update ndf_update_file_fk with process seq number
     *  
     */
    public void updateNdfUpdateFileFk(NdfUpdateFileVo ndfUpdateFileVo){
        eplNdfOutgoingDifferencesDao.updateNdfUpdateFileFk(returnedOutgoingDifferences, ndfUpdateFileVo);
    }
    
    /**
     * update ndf_update_file_fk with process seq number
     *  
     */
    public void removeNdfUpdateFileFk(Long fileSeqNo){
        eplNdfOutgoingDifferencesDao.removeNdfUpdateFileFk(fileSeqNo);
    }
    
    
    public void updateRematchNdfUpdateFileFk(Date startDate, NdfUpdateFileVo ndfUpdateFileVo){          
        ndfUpdateProcessMiscData.getEplRematchSuggestionDao().updateRematchNdfUpdateFileFk(startDate, ndfUpdateFileVo);
    }
    
    
    public void removeRematchNdfUpdateFileFk(Long fileSeqNo){
        ndfUpdateProcessMiscData.getEplRematchSuggestionDao().removeNdfUpdateFileFk(fileSeqNo);
    }
    
    /**
     * getManager returns the JNDI lookup for the manger (threadsafe version) if on the weblogic server
     * and uses the spring injected manager (ie. on the dev box) if now JNDI lookup is available.
     * 
     * @return FDBDataManager
     * @throws NamingException 
     */
    public FDBDataManager getManager() throws NamingException  {
        FDBDataManager manager = null;

        try {
            JdbcConnectionFactory factory = new JdbcConnectionFactory();
            factory.setDataSource(getDataSource());
            manager = FDBDataManager.getInstanceUsingFactory(factory);
        } catch (NamingException e) {
            manager = this.getManager();
            LOG.error("Exception caught in NdfUpdateProcessCapabilityImpl.getManager()" + e.getMessage(), e);
        }

        return manager;
    }

    /**
     * Uses JNDI lookup to get the datasource. 
     * 
     * @return DataSource
     * @throws NamingException NamingException
     */
    private DataSource getDataSource() throws NamingException {

        // Obtain our environment naming context
        Context initCtx;
        DataSource datasource = null;

        ConfigFileUtility cfu = new ConfigFileUtility();
        initCtx = new InitialContext();
        Hashtable<String, String> ht = new Hashtable<String, String>();

        ht.put(Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory");

        ht.put(Context.PROVIDER_URL, "t3://localhost:" + cfu.getPort());

        initCtx = new InitialContext(ht);

        // Lookup this DataSouce at the top level of the WebLogic JNDI tree
        datasource = (DataSource) initCtx
            .lookup("datasource.FDB-DIF");

        return datasource;
    }
    
    /**
     * @param fdbMonographPemVDomainCapability the ndfUpdateProcessPemDomainCapability to set
     */
    public void setFdbMonographPemVDomainCapability(FdbMonographPemVDomainCapability fdbMonographPemVDomainCapability) {
        this.fdbMonographPemVDomainCapability = fdbMonographPemVDomainCapability;
    }

    /**
     * @return the ndfUpdateProcessPemDomainCapability
     */
    public FdbMonographPemVDomainCapability getFdbMonographPemVDomainCapability() {
        return fdbMonographPemVDomainCapability;
    }

    /**
     * @param ndfUpdateProcessPlblDomainCapability the ndfUpdateProcessPlblDomainCapability to set
     */
    public void setFdbPlblwarningsVDomainCapability(FdbPlblwarningsVDomainCapability fdbPlblwarningsVDomainCapability) {
        this.fdbPlblwarningsVDomainCapability = fdbPlblwarningsVDomainCapability;
    }

    /**
     * @return the ndfUpdateProcessPlblDomainCapability
     */
    public FdbPlblwarningsVDomainCapability getdbPlblwarningsVDomainCapability() {
        return fdbPlblwarningsVDomainCapability;
    }

    /**
     * @return the fdbGcnseqnoPlbwlVDomainCapability
     */
    public FdbGcnseqnoPlblwVDomainCapability getFdbGcnseqnoPlblwVDomainCapability() {
        return fdbGcnseqnoPlblwVDomainCapability;
    }

    /**
     * @param fdbGcnseqnoPlblwVDomainCapability the fdbGcnseqnoPlbwVDomainCapability to set
     */
    public void setFdbGcnseqnoPlblwVDomainCapability(FdbGcnseqnoPlblwVDomainCapability fdbGcnseqnoPlblwVDomainCapability) {
        this.fdbGcnseqnoPlblwVDomainCapability = fdbGcnseqnoPlblwVDomainCapability;
    }

    /**
     * @return the fdbGcnseqnoPemVDomainCapability
     */
    public FdbGcnseqnoPemVDomainCapability getFdbGcnseqnoPemVDomainCapability() {
        return fdbGcnseqnoPemVDomainCapability;
    }

    /**
     * @param fdbGcnseqnoPemVDomainCapability the fdbGcnseqnoPemVDomainCapability to set
     */
    public void setFdbGcnseqnoPemVDomainCapability(FdbGcnseqnoPemVDomainCapability fdbGcnseqnoPemVDomainCapability) {
        this.fdbGcnseqnoPemVDomainCapability = fdbGcnseqnoPemVDomainCapability;
    }

    public ProductDomainCapability getProductDomainCapability() {
        return productDomainCapability;
    }

    public void setProductDomainCapability(ProductDomainCapability productDomainCapability) {
        this.productDomainCapability = productDomainCapability;
    }

    public NdfUpdateMonographPemMapping getNdfUpdateMonographPemMapping() {
        return ndfUpdateMonographPemMapping;
    }

    public void setNdfUpdateMonographPemMapping(NdfUpdateMonographPemMapping ndfUpdateMonographPemMapping) {
        this.ndfUpdateMonographPemMapping = ndfUpdateMonographPemMapping;
    }

    public NdfUpdatePlblwarningsMapping getNdfUpdatePlblwarningsMapping() {
        return ndfUpdatePlblwarningsMapping;
    }

    public void setNdfUpdatePlblwarningsMapping(NdfUpdatePlblwarningsMapping ndfUpdatePlblwarningsMapping) {
        this.ndfUpdatePlblwarningsMapping = ndfUpdatePlblwarningsMapping;
    }

    public NdfUpdateVaProductAssociationsMapping getNdfUpdateVaProductAssociationsMapping() {
        return ndfUpdateVaProductAssociationsMapping;
    }

    public void setNdfUpdateVaProductAssociationsMapping(
        NdfUpdateVaProductAssociationsMapping ndfUpdateVaProductAssociationsMapping) {
        this.ndfUpdateVaProductAssociationsMapping = ndfUpdateVaProductAssociationsMapping;
    }

    /**
     * @return the ndfUpdateNdfDataMapping
     */
    public NdfUpdateNdfDataMapping getNdfUpdateNdfDataMapping() {
        return ndfUpdateNdfDataMapping;
    }

    /**
     * @param ndfUpdateNdfDataMapping the ndfUpdateNdfDataMapping to set
     */
    public void setNdfUpdateNdfDataMapping(NdfUpdateNdfDataMapping ndfUpdateNdfDataMapping) {
        this.ndfUpdateNdfDataMapping = ndfUpdateNdfDataMapping;
    }

    /**
     * @return the ndfOutgoingDifferences
     */
    public EplNdfOutgoingDifferencesDao getEplNdfOutgoingDifferencesDao() {
        return eplNdfOutgoingDifferencesDao;
    }

    /**
     * @param ndfOutgoingDifferences the ndfOutgoingDifferences to set
     */
    public void setEplNdfOutgoingDifferencesDao(EplNdfOutgoingDifferencesDao eplNdfOutgoingDifferencesDao) {
        this.eplNdfOutgoingDifferencesDao = eplNdfOutgoingDifferencesDao;
    }
   
    /**
     * @return the nationalSettingDomainCapability
     */
    public NationalSettingDomainCapability getNationalSettingDomainCapability() {
        return nationalSettingDomainCapability;
    }
    
    /**
     * @param nationalSettingDomainCapability the nationalSettingDomainCapability to set
     */
    public void setNationalSettingDomainCapability(NationalSettingDomainCapability nationalSettingDomainCapability) {
        this.nationalSettingDomainCapability = nationalSettingDomainCapability;
    }
   
    /**
     * @return the ndfUpdateProcessMiscData
     */
    public NdfUpdateProcessMiscData getNdfUpdateProcessMiscData() {
        return ndfUpdateProcessMiscData;
    }
   
    /**
     * @param ndfUpdateProcessMiscData the ndfUpdateProcessMiscData to set
     */
    public void setNdfUpdateProcessMiscData(NdfUpdateProcessMiscData ndfUpdateProcessMiscData) {
        this.ndfUpdateProcessMiscData = ndfUpdateProcessMiscData;
    }

    /**
     * @return the maxEnglishMonographId
     */
    public Long getMaxMonographId() {
        return maxMonographId;
    }

    /**
     * @param maxEnglishMonographId the maxEnglishMonographId to set
     */
    public void setMaxMonographId(Long maxMonographId) {
        this.maxMonographId = maxMonographId;
    }

    
    public MessageDataCapability getMessageDataCapability() {
        return messageDataCapability;
    }

    
    public void setMessageDataCapability(MessageDataCapability messageDataCapability) {
        this.messageDataCapability = messageDataCapability;
    }
    
    
    public List<String>  getPreviewUpdateFileReportData(Date startDTM) {
        
        LOG.info("---------------generating update file preview report-------------------");
                 
        return messageDataCapability.generateUpdateFilePreviewReport(startDTM);
    }

    /**
     * Allows the WordProcessingFieldHelper to utilize to be set.
     * 
     * @param wordProcessingFieldHelper the helper to process VistA Word-Processing fields.
     */
    @Required
    public void setWordProcessingFieldHelper( WordProcessingFieldHelper wordProcessingFieldHelper) {
    	this.wordProcessingFieldHelper = wordProcessingFieldHelper;
    }


    @Override
    public void removeAllFileAssociations(Long fileSeqNo) {
        removeNdfUpdateFileFk(fileSeqNo);
        removeRematchNdfUpdateFileFk(fileSeqNo);        
    }
}
