package gov.va.med.pharmacy.peps.service.common.capability.impl;


import gov.va.med.pharmacy.peps.common.exception.ValidationException;
import gov.va.med.pharmacy.peps.common.vo.DrugDrugInteractionVo;
import gov.va.med.pharmacy.peps.common.vo.IngredientVo;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.domain.common.capability.DrugDrugInteractionDomainCapability;

/**
 * @author serverbutts
 * DrugDrugInteractionRulesCapabilityImpl
 *
 */
public class DrugDrugInteractionRulesCapabilityImpl extends DefaultRulesCapabilityImpl<IngredientVo> {

    private DrugDrugInteractionDomainCapability drugDrugInteractionDomainCapability;


    /**
     * Enforce additional DDI rules beyond simple ValueObject validation.
     * 
     * @param drugDrugInteraction {@link DrugDrugInteractionVo} to validate
     * @param user UserVo for which to validate
     * @param canPerformUpdate boolean indicating if the call is allowed to perform updates on other items     
     * @throws ValidationException if general validation error
     */
    
    protected void handleEnforceRules(DrugDrugInteractionVo drugDrugInteraction, UserVo user, boolean canPerformUpdate)
        throws ValidationException {

        
    }


    
    /**
     * @param drugDrugInteractionDomainCapability the drugDrugInteractionDomainCapability to set
     */
    public void setDrugDrugInteractionDomainCapability(DrugDrugInteractionDomainCapability drugDrugInteractionDomainCapability) {
        this.drugDrugInteractionDomainCapability = drugDrugInteractionDomainCapability;
    }
    
    
   
}
