package gov.va.med.pharmacy.peps.service.common.capability;

import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;
import gov.va.med.pharmacy.peps.service.common.utility.NdfUpdateProcessFile;

import java.io.IOException;

/**
 * An interface that helps in writing Word Processing fields to the NDF Update File.
 * 
 * @author vhaisaduffg
 *
 */
public interface WordProcessingFieldHelper {

    /**
     * Check the VistA File Number and Field Number to see if the value is a
     * Word-Processing field in VistA.
     * 
     * @param fileNumber the file number in VistA
     * @param fieldNumber the field number in VistA
     * @return boolean true if the field is a Word-Processing field
     */
    boolean isWordProcessingField(String fileNumber, String fieldNumber);

    /**
     * Breaks up longer Strings into multiple Strings that are a maximum length
     * of MAX_VISTA_FIELD_LEN. These multiple Strings are then formatted and
     * written to the update file.
     * 
     * @param ndfUpdateFile
     *            The NdfUpdateProcessFile being used.
     * @param difference
     *            The current difference being processed.
     * @param fileNumber
     *            The VistA File Number
     * @param fieldNumber
     *            The VistA Field Number
     * @throws IOException
     *             If an error occurs writing to the NdfUpdateProcessFile.
     */
    void formatWordProcessingField(NdfUpdateProcessFile ndfUpdateFile,
            EplNdfOutgoingDifferences difference, String fileNumber,
            String fieldNumber) throws IOException;
}
