package gov.va.med.pharmacy.peps.service.common.capability;

import gov.va.med.pharmacy.peps.common.vo.RematchSuggestionVo;
import gov.va.med.pharmacy.peps.common.vo.UserVo;

import java.util.List;


public interface RematchSuggestionCapability {
    
    /**
     * 
     * 
     * @return List<RematchSuggestionVo> list of re-match
     */
    List<RematchSuggestionVo> retrieveAllRematch();
    
    public void removeObsoleteProducts();

    public void addUnmatchedProducts(UserVo user);

    public List<RematchSuggestionVo> retrieveUnmatched(Long matchTypeId);

    public Long retrieveProductId(String productIen);

    public List<Object[]> findRematchProducts(Long productId);

    public void updateRematch(Long rematchId, String matchIen, Boolean autoMatch);

}
