/**
 * Source file created in 2007 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.external.common.preencapsulation.session.impl;


import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.pharmacy.peps.external.common.preencapsulation.inbound.capability.SynchronizationStatusCapability;
import gov.va.med.pharmacy.peps.external.common.preencapsulation.session.SynchronizationStatusService;


/**
 * Process VistA Synchronization status messages.
 */
@Service
public class SynchronizationStatusServiceImpl implements SynchronizationStatusService {
    private SynchronizationStatusCapability synchronizationStatusCapability;

    /**
     * Process status update.
     * 
     * @param status VistA Status
     * @return Response
     */
    @Transactional
    public String processStatus(String status) {
        return synchronizationStatusCapability.processRequest(status);
    }

    /**
     * Message sent count.
     * 
     * @return count
     */
    @Transactional(readOnly=true)
    public long getVistaMessageSentCount() {
        return synchronizationStatusCapability.getVistaMessageSentCount();
    }

    /**
     * Message processed count.
     * 
     * @return count
     */
    @Transactional(readOnly=true)
    public long getVistaMessageProcessedCount() {
        return synchronizationStatusCapability.getVistaMessageProcessedCount();
    }

    /**
     * Set capability.
     * 
     * @param synchronizationStatusCapability capability
     */
    public void setSynchronizationStatusCapability(SynchronizationStatusCapability synchronizationStatusCapability) {
        this.synchronizationStatusCapability = synchronizationStatusCapability;
    }
}
