package gov.va.med.pharmacy.peps.external.common.utility;

import java.sql.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;

import junit.framework.TestCase;


public class MumpsConverterIT extends TestCase {

    private static final Long JANUARY_1_1985 = 473403600624L;
    private static final String JANUARY_1_1985_CONVERTED = "2850101";
    private static final String TIME_RESULT = "38058";
    private static final String DATE_TIME_RESULT = JANUARY_1_1985_CONVERTED + "." + TIME_RESULT;
    
    public void testDateConversion() {
        Date dateToConvert = new Date(JANUARY_1_1985);
        String convertedDate = MumpsConverter.convertDate(dateToConvert);
        assertEquals(JANUARY_1_1985_CONVERTED, convertedDate);
    }
    
    public void testTimeConversion() {
        GregorianCalendar timeToConvert = new GregorianCalendar();
        timeToConvert.setTimeInMillis(JANUARY_1_1985);
        timeToConvert.set(Calendar.HOUR, 22);
        timeToConvert.set(Calendar.MINUTE, 34);
        timeToConvert.set(Calendar.SECOND, 18);
        timeToConvert.set(Calendar.MILLISECOND, 0);
        String convertedTime = MumpsConverter.convertTime(timeToConvert.getTime());
        assertEquals(TIME_RESULT, convertedTime);
    }
    
    public void testDateTimeConversion() {
        GregorianCalendar timeToConvert = new GregorianCalendar();
        timeToConvert.setTimeInMillis(JANUARY_1_1985);
        timeToConvert.set(Calendar.HOUR, 22);
        timeToConvert.set(Calendar.MINUTE, 34);
        timeToConvert.set(Calendar.SECOND, 18);
        timeToConvert.set(Calendar.MILLISECOND, 0);
        String convertedTime = MumpsConverter.convertDateTime(timeToConvert.getTime());
        assertEquals(DATE_TIME_RESULT, convertedTime);
    }
}
