/**
 * Source file created in 2007 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.external.tools.pseudonym;


/**
 * ServiceTestSampleXML
 * 
 */
public class ServiceTestSampleXML {

    private static String DRUGUNITSYNC = "<drugUnitSyncRequest";
    private static String VADISPENSEUNITSYNC = "<vaDispenseUnitSyncRequest";
    private static String VAGENERICNAMESYNC = "<vaGenericNameSyncRequest";
    private static String DOSAGEFORMSYNC = "<dosageFormSyncRequest";
    private static String DRUGCLASSSYNC = "<drugClassSyncRequest";
    private static String DRUGINGREDIENTSSYNC = "<drugIngredientSyncRequest";
    private static String PRODUCTSYNC = "<vaProductSyncRequest";
    private static String NDCSYNC = "<ndcSyncRequest";
    private static String MANUFACTURERSYNC = "<manufacturerSyncRequest";
    private static String PACKAGETYPESYNC = "<packageTypeSyncRequest";
    private static String XML = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema\">";

    /**
     * default Constructor
     */
    public ServiceTestSampleXML() {
    }

 
    /**
     * getSyncXML
     * 
     * @param request
     *            request
     * @return String
     */
    public String getSyncXML(String request) {

        if (request.contains(DRUGUNITSYNC)) {
            return createSyncXML();
        } else if (request.contains(VADISPENSEUNITSYNC)) {
            return createSyncXML();
        } else if (request.contains(VAGENERICNAMESYNC)) {
            return createSyncXML();
        } else if (request.contains(DOSAGEFORMSYNC)) {
            return createSyncXML();
        } else if (request.contains(DRUGCLASSSYNC)) {
            return createSyncXML();
        } else if (request.contains(DRUGINGREDIENTSSYNC)) {
            return createSyncXML();
        } else if (request.contains(PRODUCTSYNC)) {
            return createSyncXML();
        } else if (request.contains(NDCSYNC)) {
            return createSyncXML();
        } else if (request.contains(MANUFACTURERSYNC)) {
            return createSyncXML();
        } else if (request.contains(PACKAGETYPESYNC)) {
            return createSyncXML();
        } else {
            
            return "";
        }
    }

    /**
     * createSyncXML
     * 
     * @return xml
     */
    public String createSyncXML() {

        StringBuilder a = new StringBuilder();
        a.append("<Response type=\"array\"><![CDATA[");
        a.append("<syncResponse ");
        a.append("xmlns=\"gov/va/med/pharmacy/peps/external/common/vo/inbound/sync/syncResponse\" ");
        a.append(XML);
        a.append("<syncResponseType><status>Success</status></syncResponseType><ien>90123</ien>");
        a.append("</syncResponse>]]></Response>");

        return a.toString();
    }


    
}
