package gov.va.med.pharmacy.peps.external.common.utility;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

/**
 * A utility class to handle conversions from Java objects in to Mumps formats.
 * 
 * @author vhaisaduffg
 *
 */
public class MumpsConverter {

    private static final SimpleDateFormat dateFormat = new SimpleDateFormat("YYMMdd");
   
    /**
     * Hide the constructor so an instance of this class cannot be created.
     */
    private MumpsConverter() {
        
    }
    
    /**
     * Converts the Time for the passed in Date object in to Mumps format.
     * 
     * @param time
     * @return String
     */
    public static String convertDate(Date date) {
        StringBuilder convertedDate = new StringBuilder();
        
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        int year = cal.get(Calendar.YEAR);
        
        convertedDate.append("" + ((year - 1700)/100));
        convertedDate.append(dateFormat.format(date));
        
        return convertedDate.toString();
    }
    
    /**
     * Converts the Time for the passed in Date object in to Mumps format.
     * 
     * @param time
     * @return String
     */
    public static String convertTime(Date time) {
        GregorianCalendar time2 = new GregorianCalendar();
        time2.setTime(time);
        time2.set(Calendar.HOUR, 0);
        time2.set(Calendar.MINUTE, 0);
        time2.set(Calendar.SECOND, 0);
        time2.set(Calendar.MILLISECOND, 0);
        
        return Long.toString((time.getTime() - time2.getTimeInMillis())/1000);
    }
    
    /**
     * Converts the Date and Time for the passed in Date object in to Mumps format.
     * 
     * @param dateTime
     * @return String
     */
    public static String convertDateTime(Date dateTime) {
        StringBuilder sb = new StringBuilder();
        
        sb.append(convertDate(dateTime));
        sb.append(".");
        sb.append(convertTime(dateTime));
        
        return sb.toString();
        
    }
}
