package gov.va.med.pharmacy.peps.domain.common.utility.converter.test;


import java.util.Date;

import gov.va.med.pharmacy.peps.common.vo.ItemStatus;
import gov.va.med.pharmacy.peps.common.vo.PackageSizeVo;
import gov.va.med.pharmacy.peps.common.vo.RequestItemStatus;
import gov.va.med.pharmacy.peps.common.vo.RequestRejectionReason;
import gov.va.med.pharmacy.peps.domain.common.model.EplPackageSizeDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplPackageSizeDo;
import gov.va.med.pharmacy.peps.domain.common.utility.converter.PackageSizeConverter;

import junit.framework.TestCase;


/**
 * Test the {@link PackageSizeConverter}
 */
public class PackageSizeConverterTest extends TestCase {

    private static final String NAME = "Field value here".toUpperCase();
    private static final Long EPL_ID = 9999L;
    private static final Double PACKAGE_SIZE = 999.99;
    private static final Long NDF_PACKAGESIZE_IEN = 3L;

    private PackageSizeConverter packageSizeConverter = new PackageSizeConverter();

    /**
     * 
     * @return EplSearchTemplateDo
     */
    private EplPackageSizeDo createDo() {
        EplPackageSizeDo dataDo = new EplPackageSizeDo();

        dataDo.setEplId(EPL_ID);
        dataDo.setPackageSize(PACKAGE_SIZE);
        dataDo.setNdfPackageSizeIen(NDF_PACKAGESIZE_IEN);
        
        return dataDo;
    }

    /**
     * Test
     */
    public void testToPackageSizeVoHasAllAttributes() {
        EplPackageSizeDo dataDo = createDo();
        PackageSizeVo objectVo = packageSizeConverter.convert(dataDo);

        assertEquals("EPL_ID ", EPL_ID.toString(), objectVo.getEplId());
        assertEquals("PACKAGE_SIZE ", PACKAGE_SIZE, objectVo.getPackageSize());
        assertEquals("NDF_PACKAGESIZE_IEN ", NDF_PACKAGESIZE_IEN.toString(), objectVo.getNdfPackageSizeIen());
    }

    /**
     * 
     * @return EplSearchTemplateDo
     */
    private PackageSizeVo createVo() {
        PackageSizeVo objectVo = new PackageSizeVo();

        objectVo.setEplId(String.valueOf(EPL_ID));
        objectVo.setPackageSize(PACKAGE_SIZE);
        objectVo.setNdfPackageSizeIen(NDF_PACKAGESIZE_IEN.toString());

        return objectVo;
    }

    /**
     * Test
     */
    public void testToDoHasAttributes() {
        PackageSizeVo objectVo = createVo();
        EplPackageSizeDo dataDo = packageSizeConverter.convert(objectVo);

        assertEquals("EPL_ID", EPL_ID, dataDo.getEplId());
        assertEquals("PACKAGE_SIZE", PACKAGE_SIZE, dataDo.getPackageSize());
        assertEquals("NDF_PACKAGESIZE_IEN", NDF_PACKAGESIZE_IEN, dataDo.getNdfPackageSizeIen());
    }
}
