package gov.va.med.pharmacy.peps.domain.common.dao.impl.test;

import gov.va.med.pharmacy.peps.domain.common.dao.impl.EplNdfOutgoingDifferencesDaoImpl;
import gov.va.med.pharmacy.peps.domain.common.dao.impl.EplStatusDaoImpl;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfUpdateFileDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplStatusDo;
import gov.va.med.pharmacy.peps.domain.common.utility.test.AbstractTransactionalUnitTest;

import java.util.Calendar;

import junit.framework.Assert;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class EplNdfOutgoingDifferencesDaoImplIT extends AbstractTransactionalUnitTest {
    
    @Autowired
    EplNdfOutgoingDifferencesDaoImpl eplNdfOutgoingDifferencesDao;
    
    @Autowired
    EplStatusDaoImpl eplStatusDaoImpl;
    
    @Test
    @Transactional(readOnly=true)
    public void testFindById() {
        
    }

    @Test
    @Transactional
    public void testSave() {
        EplNdfUpdateFileDo ndcUpdateFileFk = createNewUpdateFile();
        
        EplNdfOutgoingDifferences differences = new EplNdfOutgoingDifferences();
        differences.setActionType("type");
        differences.setCreatedBy("me");
        differences.setCreatedDtm(Calendar.getInstance().getTime());
        differences.setNewValue("1");
        differences.setVistaFieldNumber("01");
        differences.setVistaFileNumber("3212");
        differences.setVistaIen("111L");
        differences.setNdcUpdateFileFk(ndcUpdateFileFk);
        
        differences = eplNdfOutgoingDifferencesDao.save(differences);
        System.out.println(differences.getId());
        Assert.assertNotNull(differences.getId());
        
    }

    /**
     * 
     */
    private EplNdfUpdateFileDo createNewUpdateFile() {
        EplNdfUpdateFileDo eplNdfUpdateFileDo = new EplNdfUpdateFileDo();
        eplNdfUpdateFileDo.setComments("sdfsfd");
        eplNdfUpdateFileDo.setCreatedBy("me");
        eplNdfUpdateFileDo.setCreatedDtm(Calendar.getInstance().getTime());
        eplNdfUpdateFileDo.setDirectoryPath("/path");
        EplStatusDo status = eplStatusDaoImpl.retrieve(1L);
        eplNdfUpdateFileDo.setEplStatus(status);
        return eplNdfUpdateFileDo;
    }

}
