package gov.va.med.pharmacy.peps.domain.common.dao.impl.test;

import gov.va.med.pharmacy.peps.domain.common.dao.EplDrugDrugInteractionDao;
import gov.va.med.pharmacy.peps.domain.common.model.EplDdiSeverityDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplDrugDrugInteractionDo;
import gov.va.med.pharmacy.peps.domain.common.model.EplIngredientDo;
import gov.va.med.pharmacy.peps.domain.common.utility.test.AbstractTransactionalUnitTest;

import java.util.Calendar;

import junit.framework.Assert;

import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class EplDrugDrugInteractionDaoImplIT extends AbstractTransactionalUnitTest {
    
    @Autowired    
    private EplDrugDrugInteractionDao drugDrugInteractionDaoImpl;
    
    
      

    @Test
    @Transactional
    public void testSave() {
        
       
        EplIngredientDo drugIngredient1 = new EplIngredientDo();
        EplIngredientDo drugIngredient2 = new EplIngredientDo();
        EplDdiSeverityDo severity = new EplDdiSeverityDo();
        severity.setSeverityId(1);
        severity.setName("SIGNIFICANT");
        severity.setCreatedBy("360");
        severity.setCreatedDtm(Calendar.getInstance().getTime());
        severity.setLastModifiedBy("360");
        severity.setLastModifiedDtm(Calendar.getInstance().getTime());
        
        
        EplDrugDrugInteractionDo drugInteraction =  new EplDrugDrugInteractionDo();
        
        drugInteraction.setInteractionName("GEMIFLOXACIN MESYLATE/AGALSIDASE BETA");     
        
        drugInteraction.setDrugIngredient1(drugIngredient1);
        drugInteraction.setDrugIngredient2(drugIngredient2);
        drugInteraction.setSeverity(severity);
        
        drugInteraction.setNationallyEntered(true);
        drugInteraction.setTotalIndexes(new Long(0));
        drugInteraction.setLocallyEdited(false);
        drugInteraction.setVistaIen(6680L);
        drugInteraction.setCreatedBy("360");
        drugInteraction.setCreatedDtm(Calendar.getInstance().getTime());
        drugInteraction.setInactivationDate(null);
        drugInteraction.setLastModifiedBy("360");
        drugInteraction.setLastModifiedDtm(Calendar.getInstance().getTime());
        
        
        
        drugInteraction = drugDrugInteractionDaoImpl.save(drugInteraction);
        System.out.println(drugInteraction.getEplDrugDrugInteractionId());
        Assert.assertNotNull(drugInteraction.getEplDrugDrugInteractionId());
        
    }

   

}
