/**
 * Source file created in 2007 by Southwest Research Institute
 */


package gov.va.med.pharmacy.peps.domain.common.capability.test;


import java.util.Date;
import java.util.List;

import gov.va.med.pharmacy.peps.common.utility.PPSConstants;
import gov.va.med.pharmacy.peps.common.vo.ItemStatus;
import gov.va.med.pharmacy.peps.common.vo.PackageSizeVo;
import gov.va.med.pharmacy.peps.common.vo.RequestItemStatus;
import gov.va.med.pharmacy.peps.domain.common.capability.PackageSizeDomainCapability;


/**
 * PackageSizeDomainCapabilityTest.
 */
public class PackageSizeDomainCapabilityIT extends DomainCapabilityTestCase {
    
    private static final String IEN = "344534";
    private static final Long REV = 3L;
    private static final int PAGE_SIZE = 10;
    
//    private PackageSizeDomainCapability localpackageSizeDomainCapability;
    private PackageSizeDomainCapability nationalpackageSizeDomainCapability;

    /**
     * Retrieve the capability being tested from the Spring application context.
     * 
     * @see junit.framework.TestCase#setUp()
     */
    @Override
    protected void setUp() {
        
//        this.localpackageSizeDomainCapability = getLocalOneCapability(PackageSizeDomainCapability.class);
        this.nationalpackageSizeDomainCapability = getNationalCapability(PackageSizeDomainCapability.class);
    }


    /**
     * This method gets all the FdbMfg in the db.
     * 
     * @throws Exception Exception
     */
    public void testFindAllPackageSizeNational() throws Exception {

        List<PackageSizeVo> rCollection = nationalpackageSizeDomainCapability.retrieve();

        PackageSizeVo dataVo = buildVo("name7");
        nationalpackageSizeDomainCapability.create(dataVo, getTestUser());

        assertTrue("Collection returned correct number", rCollection.size() + 1 > rCollection.size());
    }

    /**
     * This method buidlsVO
     * 
     * @param name String
     * @return PackageSizeVo
     */
    private PackageSizeVo buildVo(String name) {
        PackageSizeVo dataVo = new PackageSizeVo();
        dataVo.setValue(name);
        dataVo.setInactivationDate(new Date());
        dataVo.setItemStatus(ItemStatus.INACTIVE);
        dataVo.setRequestItemStatus(RequestItemStatus.PENDING);
        dataVo.setRejectionReasonText("none");
        dataVo.setRevisionNumber(REV);
        dataVo.setNdfPackageSizeIen(IEN);

        return dataVo;
    }

//    /**
//     * This method gets all the FdbMfg in the db.
//     * 
//     * @throws Exception
//     */
//    public void testCreatePackageSizeLocal() throws Exception {
//
//        PackageSizeVo dataVo = buildVo("naem1");
//
//        PackageSizeVo returnedVo = localpackageSizeDomainCapability.create(dataVo, getTestUser());
//        assertNotNull("Returned NdcUnit with id", returnedVo.getId());
//    }

    /**
     * This method gets all the FdbMfg in the db.
     * 
     * @throws Exception Exception
     */
    public void testCreatePackageSizeNational() throws Exception {

        PackageSizeVo dataVo = buildVo("name8");

        PackageSizeVo returnedVo = nationalpackageSizeDomainCapability.create(dataVo, getTestUser());
        assertNotNull("Returned NdcUnit with id", returnedVo.getId());
        assertEquals("IENS should match", returnedVo.getNdfPackageSizeIen(), dataVo.getNdfPackageSizeIen());
    }

//    /**
//     * This method gets all the FdbMfg in the db.
//     * 
//     * @throws Exception
//     */
//    public void testUpdatepackageSizeLocal() throws Exception {
//
//        List<PackageSizeVo> names = localpackageSizeDomainCapability.retrieve();
//
//        names.get(0).setRejectionReasonText("updatedRejectREasonTExt");
//
//        localpackageSizeDomainCapability.update(names.get(0), getTestUser());
//
//        PackageSizeVo retrievedUpdated = localpackageSizeDomainCapability.retrieve(names.get(0).getId());
//
//        assertEquals("Should be equal", retrievedUpdated.getRejectionReasonText(), "updatedRejectREasonTExt");
//
//    }

    /**
     * This method gets all the FdbMfg in the db.
     * 
     * @throws Exception Exception
     */
    public void testUpdatepackageSizeNational() throws Exception {

        List<PackageSizeVo> names = nationalpackageSizeDomainCapability.retrieve();

        names.get(0).setRejectionReasonText(PPSConstants.TEST_REASON_TEXT);

        nationalpackageSizeDomainCapability.update(names.get(0), getTestUser());

        PackageSizeVo retrievedUpdated = nationalpackageSizeDomainCapability.retrieve(names.get(0).getId());

        assertEquals("Should be equal", retrievedUpdated.getRejectionReasonText(), PPSConstants.TEST_REASON_TEXT);

    }


//    /**
//     * This method gets all the FdbMfg in the db.
//     * 
//     * @throws Exception Exception
//     */
//    public void testSearchPackageSizeNational() throws Exception {
//        int initialSize = 0;
//        SearchCriteriaVo searchCriteria = new SearchCriteriaVo(SearchDomain.SIMPLE, Environment.LOCAL);
//
//        SearchTermVo searchTerm = new SearchTermVo(EntityType.PACKAGE_SIZE, FieldKey.VALUE, "a");
//
// 
//        // Add the searchTerm for the National Package Type test.
//        List<SearchTermVo> searchTerms = new ArrayList<SearchTermVo>();
//        searchTerms.add(searchTerm);
//
//        searchCriteria.setSearchTerms(searchTerms);
//
//        searchCriteria.setSortedFieldKey(FieldKey.VALUE);
//        searchCriteria.setSortOrder(SortOrder.ASCENDING);
//        searchCriteria.setStartRow(0);
//        searchCriteria.setPageSize(PAGE_SIZE);
//
//        List<PackageSizeVo> names;
//        names = nationalpackageSizeDomainCapability.search(searchCriteria);
//        initialSize = names.size();
//
//        PackageSizeVo dataVo = buildVo("name3");
//        nationalpackageSizeDomainCapability.create(dataVo, getTestUser());
//
//        names = nationalpackageSizeDomainCapability.search(searchCriteria);
//
//        assertEquals("Returned data", (initialSize + 1), names.size());
//
//    }

    /**
     * This method gets all the FdbMfg in the db.
     * 
     * @throws Exception Exception
     */
    public void testExistspackageSizeNational() throws Exception {

        PackageSizeVo unit = buildVo("name4");
        nationalpackageSizeDomainCapability.create(unit, getTestUser());
        boolean exists = nationalpackageSizeDomainCapability.existsByUniquenessFields(unit);
        assertTrue("exists", exists);
    }

//    /**
//     * This method gets all the FdbMfg in the db.
//     * 
//     * @throws Exception
//     */
////    public void testExistspackageSizeLocal() throws Exception {
//
//        PackageSizeVo unit = buildVo("anme5");
//        unit.setItemStatus(ItemStatus.ACTIVE);
//        localpackageSizeDomainCapability.create(unit, getTestUser());
//        boolean exists = localpackageSizeDomainCapability.existsByUniquenessFields(unit);
//        assertTrue("exists", exists);
//    }
}
