

package gov.va.med.pharmacy.peps.service.common.update.impl;


import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

import gov.va.med.pharmacy.peps.common.utility.NdfProductDataConversionUtility;
import gov.va.med.pharmacy.peps.common.utility.PPSConstants;
import gov.va.med.pharmacy.peps.common.vo.ActiveIngredientVo;
import gov.va.med.pharmacy.peps.common.vo.CsFedScheduleVo;
import gov.va.med.pharmacy.peps.common.vo.DispenseUnitVo;
import gov.va.med.pharmacy.peps.common.vo.DosageFormVo;
import gov.va.med.pharmacy.peps.common.vo.DrugClassGroupVo;
import gov.va.med.pharmacy.peps.common.vo.DrugClassVo;
import gov.va.med.pharmacy.peps.common.vo.DrugUnitVo;
import gov.va.med.pharmacy.peps.common.vo.FieldKey;
import gov.va.med.pharmacy.peps.common.vo.GenericNameVo;
import gov.va.med.pharmacy.peps.common.vo.ItemStatus;
import gov.va.med.pharmacy.peps.common.vo.ManagedDataVo;
import gov.va.med.pharmacy.peps.common.vo.ManagedItemVo;
import gov.va.med.pharmacy.peps.common.vo.OrderableItemVo;
import gov.va.med.pharmacy.peps.common.vo.PossibleDosagesAutoCreate;
import gov.va.med.pharmacy.peps.common.vo.ProductPackage;
import gov.va.med.pharmacy.peps.common.vo.ProductVo;
import gov.va.med.pharmacy.peps.common.vo.RequestItemStatus;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.common.vo.VuidStatusHistoryVo;
import gov.va.med.pharmacy.peps.common.vo.diff.Difference;
import gov.va.med.pharmacy.peps.external.common.vo.outbound.common.ItemAction;
import gov.va.med.pharmacy.peps.service.common.update.NdfFileSyncProcessor;
import gov.va.med.pharmacy.peps.external.common.utility.AbstractConverter;
import gov.va.med.pharmacy.peps.external.common.utility.MumpsConverter;


public class VaProductNdfFileSyncProcessor extends AbstractSimpleNdfFileSyncProcessor implements NdfFileSyncProcessor {

    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager
        .getLogger(VaProductNdfFileSyncProcessor.class);
    private static final String MASTERVUID_FIELD_NUMBER = "99.98";
    private static final String VUID_FIELD_NUMBER = "99.99";
    private static final String CHILD_FIELD_NUMBER01 = "99.991,.01";
    private static final String CHILD_FIELD_NUMBER02 = "99.991,.02";
    private static final String GENERIC_IEN_FIELD_NUMBER = ".05";
    private static final String DOSAGEFORM_FIELD_NUMBER = "1";
    private static final String STRENGTH_FIELD_NUMBER = "2";
    private static final String PRODUCTUNIT_FIELD_NUMBER = "3";
    private static final String NATIONALFORMULARY_FIELD_NUMBER = "4";
    private static final String VAPRINTNAME_FIELD_NUMBER = "5";
    private static final String VAPRODUCTIDENTIFIER_FIELD_NUMBER = "6";
    private static final String CMOPINDICATOR_FIELD_NUMBER = "7";
    private static final String DISPENSEUNIT_FIELD_NUMBER = "8";
    private static final String GCNSEQUENCE_FIELD_NUMBER = "11";
    private static final String PRIMARYDRUGCLASS_FIELD_NUMBER = "15";
    private static final String SECONDARYDRUGCLASS_FIELD_NUMBER = "16,.01";    
    private static final String NATFORMULARYIND_FIELD_NUMBER = "17";
    private static final String CHILD_ING_FIELD_NUMBER01 = "14,.01";
    private static final String CHILD_ING_FIELD_NUMBER1 = "14,1";
    private static final String CHILD_ING_FIELD_NUMBER2 = "14,2";
    private static final String CSFEDSCH_FIELD_NUMBER = "19";
    private static final String SOURCE_FIELD_NUMBER = "20";
    private static final String STATUS_FIELD_NUMBER = "21";
    private static final String OVERRIDEDF_FIELD_NUMBER = "31";
    private static final String EXCLUDEDRUGINT_FIELD_NUMBER = "23";
    private static final String DEFAULTPOSDOSAGE_FIELD_NUMBER = "40";
    private static final String POSSIBLEDOSAGE_FIELD_NUMBER = "41";
    private static final String PRODUCTPACK_FIELD_NUMBER = "42";
    private static final String FDAMEDGUIDE_FIELD_NUMBER = "100";
    private static final String SERVICECODE_FIELD_NUMBER = "2000";
    private static final String BLANK = " "; 
    /** New hazardous waste fields for the file update process.**/
    private static final String HAZTOHAN_FIELD_NUMBER = "101";
    private static final String HAZTODIS_FIELD_NUMBER = "102";
    private static final String PRIMARY_EPA_CODE_FIELD_NUMBER = "103";
    private static final String WASTE_SORT_CODE_FIELD_NUMBER = "104";
    private static final String DOT_SHIPPING_CODE_FIELD_NUMBER = "105";

    public VaProductNdfFileSyncProcessor(Set<FieldKey> fields, String fileNumber, String fieldAddNumber) {
        super(fields, fileNumber, fieldAddNumber);
    }

    @Override
    public void processNew(ManagedDataVo managedData) {
        // TODO Auto-generated method stub

    }

    @Override
    public void processNew(ManagedItemVo managedItem, UserVo user) {

        ProductVo vaProductVo = (ProductVo) managedItem;

        if (RequestItemStatus.APPROVED.equals(vaProductVo.getRequestItemStatus()) && vaProductVo.getValue() != null) {
            String vistaIen;
            String userValue;            
            vistaIen = vaProductVo.getNdfProductIen().toString();
            userValue = user.getUsername();            
            insertNewElement(vistaIen, vaProductVo.getVaProductName(), userValue);    
            
            String genericName = NdfProductDataConversionUtility.convertGenericName(vaProductVo.getGenericName());
            insertNewChildElement(vistaIen, genericName, userValue, GENERIC_IEN_FIELD_NUMBER);
            
            String dosageForm = NdfProductDataConversionUtility.convertDosageForm(vaProductVo.getDosageForm());
            insertNewChildElement(vistaIen, dosageForm, userValue, DOSAGEFORM_FIELD_NUMBER);
            
            String strength = NdfProductDataConversionUtility.getStringValue(vaProductVo.getProductStrength());
            insertNewChildElement(vistaIen,strength, userValue, STRENGTH_FIELD_NUMBER);
            
            insertNewChildElement(vistaIen, NdfProductDataConversionUtility.convertDrugUnit(vaProductVo.getProductUnit()), userValue, PRODUCTUNIT_FIELD_NUMBER);
            
            String nationalFormularyName = NdfProductDataConversionUtility.getStringValue(vaProductVo.getNationalFormularyName());
            insertNewChildElement(vistaIen, nationalFormularyName, userValue, NATIONALFORMULARY_FIELD_NUMBER);
            
            String vaPrintName = NdfProductDataConversionUtility.getStringValue(vaProductVo.getVaPrintName());
            insertNewChildElement(vistaIen, vaPrintName, userValue, VAPRINTNAME_FIELD_NUMBER);
            
            String cmopId = NdfProductDataConversionUtility.getStringValue(vaProductVo.getCmopId());
            insertNewChildElement(vistaIen, cmopId, userValue, VAPRODUCTIDENTIFIER_FIELD_NUMBER);
            
            // CMOP Indicator
            insertNewChildElement(vistaIen, NdfProductDataConversionUtility.convertBooleanDigit(vaProductVo.getCmopDispense()), userValue, CMOPINDICATOR_FIELD_NUMBER);
            
            String dispenseUnit = NdfProductDataConversionUtility.convertDispenseUnit(vaProductVo.getDispenseUnit());
            insertNewChildElement(vistaIen, dispenseUnit, userValue, DISPENSEUNIT_FIELD_NUMBER);
            
            String gcnSeqNumber = NdfProductDataConversionUtility.getStringValue(vaProductVo.getGcnSequenceNumber());
            insertNewChildElement(vistaIen, gcnSeqNumber, userValue, GCNSEQUENCE_FIELD_NUMBER);
                                              
            String natFormularyInd = NdfProductDataConversionUtility.convertBooleanDigit(vaProductVo.getNationalFormularyIndicator());
            insertNewChildElement(vistaIen, natFormularyInd, userValue, NATFORMULARYIND_FIELD_NUMBER);

            // Active Ingredients  
            insertAddActiveIngredients(vaProductVo.getActiveIngredients(), vistaIen, userValue);

            processNewProductDrugClasses(vaProductVo, vistaIen, userValue);
            processNewProductFields1(vaProductVo, userValue, vistaIen);
            processNewProductFields2(vaProductVo, userValue, vistaIen);
        }

    }

    /**
     * Process Drug Class Codes for a new product.  Sends the primary drug class in field 15 and 
     * any secondary drug classes in the multiple field 16.
     * @param vaProductVo
     * @param vistaIen
     * @param userValue
     */
    private void processNewProductDrugClasses(ProductVo vaProductVo, String vistaIen, String userValue) {
        for (DrugClassGroupVo drugClass : vaProductVo.getDrugClasses()) {
            if (drugClass.getPrimary()) {
                insertNewChildElement(vistaIen, getDrugClassIen(drugClass), userValue, PRIMARYDRUGCLASS_FIELD_NUMBER);
            }
            else {                    
                insertNewChildElement(vistaIen + "," + getDrugClassIen(drugClass),
                        getDrugClassIen(drugClass), 
                        userValue, SECONDARYDRUGCLASS_FIELD_NUMBER);
            }
        }
    }

    @Override
    public void processModified(ManagedDataVo managedData) {
        // TODO Auto-generated method stub

    }

    @Override
    public void processModified(ManagedItemVo managedItem, UserVo user, Collection<Difference> differences) {
        
        ProductVo vaProductVo = (ProductVo) managedItem;
        
        Map<FieldKey, Difference> setDifference = super.toSetDifference(differences);

        addDifferences(setDifference);

        boolean hasDifference =
            AbstractConverter.hasNewOrModifiedFields(super.getFields(), setDifference, ItemAction.MODIFY);

        if (hasDifference) {
            if (RequestItemStatus.APPROVED.equals(vaProductVo.getRequestItemStatus()) && vaProductVo.getValue() != null) {
                String vistaIen;
                String userValue;
                // IEN
                vistaIen = vaProductVo.getNdfProductIen().toString();
                
                userValue = user.getUsername();
                
                //Based on the KIDS output file, the most current ingredient data is always part of the build - auto added hence replicating
                insertActiveIngredients(vaProductVo.getActiveIngredients(), vistaIen, userValue);
                
                for (FieldKey key : super.getFields()) {
                    if (setDifference.containsKey(key)) {
                        if (AbstractConverter.fieldWasModified(key, differences)) {
                            if (FieldKey.ITEM_STATUS.equals(key)) {
                                modifyElement(key, setDifference.get(FieldKey.INACTIVATION_DATE), userValue, vistaIen,
                                    vaProductVo);
                            }
                            else if (FieldKey.DRUG_CLASSES.equals(key)){                                
                                processModifiedProductDrugClasses(vaProductVo, setDifference, vistaIen, userValue, key);                          
                            }
                            else {
                                modifyElement(key, setDifference.get(key), userValue, vistaIen, vaProductVo);
                            }
                        }
                    }
                }
            }
        }

    }

    /**
     * Secondary Drug Classes - if a drug class was changed from primary to secondary, it is a new secondary with no old value.
     * Likewise, if a drug class is changed from a secondary to primary, it is removed from secondary and added as a new 
     * primary.
     * @param vaProductVo
     * @param setDifference
     * @param vistaIen
     * @param userValue
     * @param key
     */
    private void processModifiedProductDrugClasses(ProductVo vaProductVo, Map<FieldKey, Difference> setDifference,
            String vistaIen, String userValue, FieldKey key) {
        //addDifferences already found primary drug class changes and stored them in setDifference under different key
        if(setDifference.get(FieldKey.PRIMARY_DRUG_CLASS) != null){
            modifyElement(key, setDifference.get(FieldKey.PRIMARY_DRUG_CLASS), userValue, vistaIen,
                vaProductVo);                                      
        }
        
        //secondary drug classes
        @SuppressWarnings("unchecked")
        Collection<DrugClassGroupVo> oldList = findSecondaryDrugClasses((Collection<DrugClassGroupVo>) 
                AbstractConverter.getOldValue(FieldKey.DRUG_CLASSES, setDifference));
        @SuppressWarnings("unchecked")
        Collection<DrugClassGroupVo> newList = findSecondaryDrugClasses((Collection<DrugClassGroupVo>) 
                AbstractConverter.getNewValue(FieldKey.DRUG_CLASSES, setDifference));               
        
        for (DrugClassGroupVo oldDrugClassGroupVo: oldList) {
            boolean foundMatch = false;
            for (DrugClassGroupVo newDrugClassGroupVo: newList) {
                if (newDrugClassGroupVo.equals(oldDrugClassGroupVo)){
                    //unchanged record, no need to send anything
                    newList.remove(oldDrugClassGroupVo);
                    foundMatch = true;
                    break;
                }
                else if (oldDrugClassGroupVo.getDrugClass().getVuid().equals(newDrugClassGroupVo.getDrugClass().getVuid())){
                    //changed
                    insertModifiedElement(vistaIen + "," + getDrugClassIen(newDrugClassGroupVo), 
                            getDrugClassIen(newDrugClassGroupVo), userValue, SECONDARYDRUGCLASS_FIELD_NUMBER, 
                            getDrugClassIen(oldDrugClassGroupVo));                   
                    newList.remove(oldDrugClassGroupVo);
                    foundMatch = true;
                    break;
                }
            }
            if (!foundMatch){
            //old didn't find a new match - send remove
                insertModifiedElement(vistaIen + "," + getDrugClassIen(oldDrugClassGroupVo), null, userValue, 
                        SECONDARYDRUGCLASS_FIELD_NUMBER, getDrugClassIen(oldDrugClassGroupVo));                                   
            }
        }
        //process any remaining new records - send new
        for (DrugClassGroupVo newDrugClassGroupVo: newList) {
            insertModifiedElement(vistaIen + "," + getDrugClassIen(newDrugClassGroupVo), getDrugClassIen(newDrugClassGroupVo),
                    userValue, SECONDARYDRUGCLASS_FIELD_NUMBER, null);                          
        }             
    }

    /**
     * @param drugClassGroupVo
     * @return
     */
    private String getDrugClassIen(DrugClassGroupVo drugClassGroupVo) {
        return (drugClassGroupVo.getDrugClass().getDrugClassIen() == null) 
                ? BLANK : drugClassGroupVo.getDrugClass().getDrugClassIen();
    }

    /**
     * Find the secondary drug class list.
     * 
     * @param group drug class group
     * @return primary drug class if found, otherwise an empty drug class
     */
    private static Collection<DrugClassGroupVo> findSecondaryDrugClasses(Collection<DrugClassGroupVo> group) {       
        if (group != null) {
            //copy the list
            List<DrugClassGroupVo> secondaryDrugClassList = new ArrayList<DrugClassGroupVo>(group);
            //loop through the original list and remove the primary from the copy
            for (DrugClassGroupVo drugClass : group) {
                if (drugClass.getPrimary()) {
                    secondaryDrugClassList.remove(drugClass);
                }
            }
            return secondaryDrugClassList;
        }

        return new ArrayList<DrugClassGroupVo>();
    }      
    
    private void processNewProductFields1(ProductVo vaProductVo, String userValue, String vistaIen) {
        if (RequestItemStatus.APPROVED.equals(vaProductVo.getRequestItemStatus()) && vaProductVo.getValue() != null) {
            // CS Federal Schedule
            if (vaProductVo.getCsFedSchedule() != null) {
                fedSchedule(vaProductVo.getCsFedSchedule(), userValue, vistaIen, null,true);
            }

            // Single/Multisource Product
            
            if (vaProductVo.getSingleMultiSourceProduct() != null) {
                if (vaProductVo.getSingleMultiSourceProduct().getValue().equals(PPSConstants.MULTISOURCE_MULTI)) {
                    insertNewChildElement(vistaIen, "M", userValue, SOURCE_FIELD_NUMBER);
                } else if (vaProductVo.getSingleMultiSourceProduct().getValue().equals(PPSConstants.MULTISOURCE_BOTH)) {
                    insertNewChildElement(vistaIen, "M", userValue, SOURCE_FIELD_NUMBER);
                } else if (vaProductVo.getSingleMultiSourceProduct().getValue().equals(PPSConstants.MULTISOURCE_SINGLE)) {
                    insertNewChildElement(vistaIen, "S", userValue, SOURCE_FIELD_NUMBER);
                }
            }               
        }
    }

    private void processNewProductFields2(ProductVo vaProductVo, String userValue, String vistaIen) {
        if (RequestItemStatus.APPROVED.equals(vaProductVo.getRequestItemStatus()) && vaProductVo.getValue() != null) {

            String overrideDfDoseChkExcl = NdfProductDataConversionUtility.convertBooleanDigit(vaProductVo.isOverrideDfDoseChkExclusn());
            insertNewChildElement(vistaIen, overrideDfDoseChkExcl, userValue, OVERRIDEDF_FIELD_NUMBER);
            
            String exclDrugIntChk = NdfProductDataConversionUtility.convertNewBooleanBlank(vaProductVo.isExcludeDrgDrgInteractionCheck());           
            insertNewChildElement(vistaIen, exclDrugIntChk, userValue, EXCLUDEDRUGINT_FIELD_NUMBER);

            // Create Default Possible Dosage
            if (vaProductVo.getCreatePossibleDosage()) {
                insertNewChildElement(vistaIen, "Y", userValue, DEFAULTPOSDOSAGE_FIELD_NUMBER);
            }
            else {
                insertNewChildElement(vistaIen, "N", userValue, DEFAULTPOSDOSAGE_FIELD_NUMBER);
                //Possible Dosages To Create
                if (vaProductVo.getPossibleDosagesAutoCreate() != null) {
                    dosageAutoCreate(vaProductVo.getPossibleDosagesAutoCreate(), userValue, vistaIen, true, null);
                }
            }

            // Product Package
            buildProductPackage(vaProductVo.getProductPackage(), userValue, vistaIen, true, null);

            // Master Entry For VUID
            insertNewChildElement(vistaIen, NdfProductDataConversionUtility.convertBooleanDigit(vaProductVo.isMasterEntryForVuid()),userValue, MASTERVUID_FIELD_NUMBER);
            
            String vuid = NdfProductDataConversionUtility.getStringValue(vaProductVo.getVuid());          
            insertNewChildElement(vistaIen,vuid, userValue, VUID_FIELD_NUMBER);
            
            String medGuide = NdfProductDataConversionUtility.getStringValue(vaProductVo.getFdaMedGuide());              
            insertNewChildElement(vistaIen, medGuide, userValue, FDAMEDGUIDE_FIELD_NUMBER);
            
            // New Hazardous waste fields for add.
            insertNewChildElement(vistaIen, NdfProductDataConversionUtility.convertBooleanDigit(vaProductVo.getHazardousToHandle()), userValue, HAZTOHAN_FIELD_NUMBER);            
            
            insertNewChildElement(vistaIen, NdfProductDataConversionUtility.convertBooleanDigit(vaProductVo.getHazardousToDispose()), userValue, HAZTODIS_FIELD_NUMBER);
            
            insertNewChildElement(vistaIen, NdfProductDataConversionUtility.getStringValue(vaProductVo.getPrimaryEpa()), userValue, PRIMARY_EPA_CODE_FIELD_NUMBER);
            
            insertNewChildElement(vistaIen, NdfProductDataConversionUtility.getStringValue(vaProductVo.getWasteSortCode()), userValue, WASTE_SORT_CODE_FIELD_NUMBER);
            
            insertNewChildElement(vistaIen, NdfProductDataConversionUtility.getStringValue(vaProductVo.getDotShippingName()), userValue, DOT_SHIPPING_CODE_FIELD_NUMBER);
            
            
            String servieCode = NdfProductDataConversionUtility.getStringValue(vaProductVo.getServiceCode());           
            insertNewChildElement(vistaIen, servieCode, userValue, SERVICECODE_FIELD_NUMBER);

            // Effective Date Time Records
            if (vaProductVo.getEffectiveDates() != null) {
                int pairValue = 0;

                for (VuidStatusHistoryVo effectiveDate : vaProductVo.getEffectiveDates()) {
                    pairValue = pairValue + 1;
                    String VistaIenChild = vistaIen + "," + pairValue;

                    insertNewChildElement(VistaIenChild, MumpsConverter.convertDate(effectiveDate.getEffectiveDateTime()), userValue,
                        CHILD_FIELD_NUMBER01);
                    insertNewChildElement(VistaIenChild, effectiveDate.getItemStatus().isActive() ? "1" : "0", userValue,
                        CHILD_FIELD_NUMBER02);
                }
            }

        }

    }

    private void modifyElement(FieldKey key, Difference diff, String userValue, String vistaIEN, ProductVo vaProductVo) {

        if (FieldKey.PRODUCT_STRENGTH.equals(key)) {
            
            String oldStrength = NdfProductDataConversionUtility.getOldValueString(diff);
            String newStrength = NdfProductDataConversionUtility.getNewValueString(diff);            
            insertModifiedElement(vistaIEN, newStrength, userValue,STRENGTH_FIELD_NUMBER, oldStrength);
            
        } else if (FieldKey.FDA_MED_GUIDE.equals(key)) {
            
            String oldMedGuide = NdfProductDataConversionUtility.getOldValueString(diff);
            String newMedGuide = NdfProductDataConversionUtility.getNewValueString(diff);
            insertModifiedElement(vistaIEN, newMedGuide, userValue,FDAMEDGUIDE_FIELD_NUMBER, oldMedGuide);
            
        } else if (FieldKey.DISPENSE_UNIT.equals(key)) {
            
            String newDispenseUnitIen = NdfProductDataConversionUtility.convertDispenseUnit((DispenseUnitVo) diff.getNewValue()); 
            String oldDispenseUnitIen = NdfProductDataConversionUtility.convertDispenseUnit((DispenseUnitVo) diff.getOldValue());            
            insertModifiedElement(vistaIEN, newDispenseUnitIen, userValue, DISPENSEUNIT_FIELD_NUMBER, oldDispenseUnitIen);            
            
        } else if (FieldKey.CMOP_ID.equals(key)) {
            String oldCmopId = NdfProductDataConversionUtility.getOldValueString(diff);
            String newCmopId = NdfProductDataConversionUtility.getNewValueString(diff);             
            insertModifiedElement(vistaIEN, newCmopId, userValue, VAPRODUCTIDENTIFIER_FIELD_NUMBER, oldCmopId);
            
        } else if (FieldKey.PRODUCT_UNIT.equals(key)) {            
            
            String oldDrugUnitIen = NdfProductDataConversionUtility.convertDrugUnit((DrugUnitVo) diff.getOldValue());
            String newDrugUnitIen = NdfProductDataConversionUtility.convertDrugUnit((DrugUnitVo) diff.getNewValue());            
            insertModifiedElement(vistaIEN, newDrugUnitIen, userValue, PRODUCTUNIT_FIELD_NUMBER, oldDrugUnitIen);
            
        } else if (FieldKey.CREATE_POSSIBLE_DOSAGE.equals(key)) {
            
            String oldPossibleDosage = NdfProductDataConversionUtility.convertYesNoValue((Boolean)diff.getOldValue());
            String newPossibleDosage = NdfProductDataConversionUtility.convertYesNoValue((Boolean)diff.getNewValue());            
            insertModifiedElement(vistaIEN, newPossibleDosage, userValue, DEFAULTPOSDOSAGE_FIELD_NUMBER, oldPossibleDosage);
            
        } else if (FieldKey.PRODUCT_PACKAGE.equals(key)) {
            
            ProductPackage productPackage = (ProductPackage) diff.getNewValue();
            ProductPackage oldProductPackage = (ProductPackage) diff.getOldValue();           
            buildProductPackage(productPackage, userValue, vistaIEN, false, oldProductPackage);
            
        } else if (FieldKey.POSSIBLE_DOSAGES_AUTO_CREATE.equals(key)) {
            
            PossibleDosagesAutoCreate autoDosage = (PossibleDosagesAutoCreate) diff.getNewValue();
            PossibleDosagesAutoCreate oldAutoDosage = (PossibleDosagesAutoCreate) diff.getOldValue();            
            dosageAutoCreate(autoDosage, userValue, vistaIEN, false,oldAutoDosage );
            
        } else if (FieldKey.VA_PRINT_NAME.equals(key)) {
            
            String oldVaPrintName = NdfProductDataConversionUtility.getOldValueString(diff);
            String newVaPrintName = NdfProductDataConversionUtility.getNewValueString(diff);            
            insertModifiedElement(vistaIEN, newVaPrintName, userValue, VAPRINTNAME_FIELD_NUMBER, oldVaPrintName);    
            
        } else if (FieldKey.NATIONAL_FORMULARY_NAME.equals(key)) {
            
            String oldNatFormularyName = NdfProductDataConversionUtility.getOldValueString(diff);
            String newNatFormularyName = NdfProductDataConversionUtility.getNewValueString(diff);            
            insertModifiedElement(vistaIEN, newNatFormularyName, userValue, NATIONALFORMULARY_FIELD_NUMBER, oldNatFormularyName);
            
        } else if (FieldKey.GENERIC_NAME.equals(key)) {
            
            String oldGenericNameIen = NdfProductDataConversionUtility.convertGenericName((GenericNameVo) diff.getOldValue());
            String newGenericNameIen = NdfProductDataConversionUtility.convertGenericName((GenericNameVo) diff.getNewValue());            
            insertModifiedElement(vistaIEN,newGenericNameIen, userValue, GENERIC_IEN_FIELD_NUMBER, oldGenericNameIen);
            
        } else if (FieldKey.TRANSMIT_TO_CMOP.equals(key)) {
            
            String oldCMOPTransmit = NdfProductDataConversionUtility.convertBooleanDigit(diff.getOldValue());
            String newCMOPTransmit = NdfProductDataConversionUtility.convertBooleanDigit(diff.getNewValue());            
            insertModifiedElement(vistaIEN, newCMOPTransmit, userValue, CMOPINDICATOR_FIELD_NUMBER, oldCMOPTransmit);
            
        } else if (FieldKey.CMOP_DISPENSE.equals(key)) {
            
            String oldCMOPIndicator = NdfProductDataConversionUtility.convertBooleanDigit(diff.getOldValue());
            String newCMOPIndicator = NdfProductDataConversionUtility.convertBooleanDigit(diff.getNewValue());            
            insertModifiedElement(vistaIEN, newCMOPIndicator, userValue, CMOPINDICATOR_FIELD_NUMBER, oldCMOPIndicator);
            
        } else if (FieldKey.NATIONAL_FORMULARY_INDICATOR.equals(key)) {
            
            String oldNatFormularyInd = NdfProductDataConversionUtility.convertBooleanDigit(diff.getOldValue());
            String newNatFormularyInd = NdfProductDataConversionUtility.convertBooleanDigit(diff.getNewValue());            
            insertModifiedElement(vistaIEN, newNatFormularyInd, userValue, NATFORMULARYIND_FIELD_NUMBER, oldNatFormularyInd);
            
        } else if (FieldKey.EXCLUDE_DRG_DRG_INTERACTION_CHECK.equals(key)) {
            
            String oldExcDrgInteractionChk = NdfProductDataConversionUtility.convertOldBooleanBlank(diff);
            String newExcDrgInteractionChk = NdfProductDataConversionUtility.convertNewBooleanBlank(diff);            
            insertModifiedElement(vistaIEN, newExcDrgInteractionChk, userValue, EXCLUDEDRUGINT_FIELD_NUMBER, oldExcDrgInteractionChk);
            
        } else if (FieldKey.OVERRIDE_DF_DOSE_CHK_EXCLUSN.equals(key)) {
            
            String oldOverrideDoseChkExcl = NdfProductDataConversionUtility.convertBooleanDigit(diff.getOldValue());
            String newOverrideDoseChkExcl = NdfProductDataConversionUtility.convertBooleanDigit(diff.getNewValue());            
            insertModifiedElement(vistaIEN, newOverrideDoseChkExcl, userValue, OVERRIDEDF_FIELD_NUMBER, oldOverrideDoseChkExcl);
            
        } else if (FieldKey.CS_FED_SCHEDULE.equals(key)) {
            CsFedScheduleVo fedSchedule = (CsFedScheduleVo) diff.getNewValue();
            CsFedScheduleVo oldFedSchedule = (CsFedScheduleVo) diff.getOldValue();
            fedSchedule(fedSchedule, userValue, vistaIEN, oldFedSchedule, false);
            
        } else if (FieldKey.DRUG_CLASSES.equals(key)) {            
            
            DrugClassVo drugClass = (DrugClassVo) diff.getNewValue();
            String newDrugClassIen = NdfProductDataConversionUtility.convertNewDrugClass(diff, vaProductVo);
            String oldDrugClassIen = NdfProductDataConversionUtility.convertOldDrugClass(diff);            
            if (drugClass != null) {
                insertModifiedElement(vistaIEN, newDrugClassIen, userValue, PRIMARYDRUGCLASS_FIELD_NUMBER, oldDrugClassIen);
            }
            
        } else if (FieldKey.ITEM_STATUS.equals(key)) {
            
            String priorInactivatedDate = convertPriorInactivationDate(diff);
            String inactivatedDate = convertInactivationDate(diff, vaProductVo);                       
            insertModifiedElement(vistaIEN, inactivatedDate, userValue, STATUS_FIELD_NUMBER, priorInactivatedDate);
            
        } else if (FieldKey.ORDERABLE_ITEM.equals(key)) {
           
            String oldOIIEN = NdfProductDataConversionUtility.convertOrderableItem((OrderableItemVo) diff.getOldValue());
            String newOIIEN = NdfProductDataConversionUtility.convertOrderableItem((OrderableItemVo) diff.getNewValue());           
            insertModifiedElement(vistaIEN, newOIIEN, userValue, DOSAGEFORM_FIELD_NUMBER, oldOIIEN);
            
        } else if (FieldKey.DOSAGE_FORM.equals(key)) {
            
            String oldDosageFormIen = NdfProductDataConversionUtility.convertDosageForm((DosageFormVo) diff.getOldValue());
            String newDosageFormIen = NdfProductDataConversionUtility.convertDosageForm((DosageFormVo) diff.getNewValue());            
            insertModifiedElement(vistaIEN, newDosageFormIen, userValue, DOSAGEFORM_FIELD_NUMBER, oldDosageFormIen);
            
        } else if (FieldKey.ACTIVE_INGREDIENT.equals(key)) {
            removedActiveIngredients(diff, vistaIEN, userValue);
        
        } else if (FieldKey.HAZARDOUS_TO_HANDLE.equals(key)) { 
        	            
            String oldHazToHandle = NdfProductDataConversionUtility.convertBooleanDigit(diff.getOldValue());
            String newHazToHandle = NdfProductDataConversionUtility.convertBooleanDigit(diff.getNewValue());
            insertModifiedElement(vistaIEN, newHazToHandle, userValue,HAZTOHAN_FIELD_NUMBER, oldHazToHandle);
            
        }  else if (FieldKey.HAZARDOUS_TO_DISPOSE.equals(key)) {
            
        	 String oldHazToDispose = NdfProductDataConversionUtility.convertBooleanDigit(diff.getOldValue());
             String newHazToDispose = NdfProductDataConversionUtility.convertBooleanDigit(diff.getNewValue());
             insertModifiedElement(vistaIEN, newHazToDispose, userValue,HAZTODIS_FIELD_NUMBER, oldHazToDispose);
            
        }  else if (FieldKey.PRIMARY_EPA.equals(key)) {
            
            String oldPrimaryEPA = NdfProductDataConversionUtility.getOldValueString(diff);
            String newPrimaryEPA = NdfProductDataConversionUtility.getNewValueString(diff);
            insertModifiedElement(vistaIEN, newPrimaryEPA, userValue,PRIMARY_EPA_CODE_FIELD_NUMBER, oldPrimaryEPA);
            
        }  else if (FieldKey.WASTE_SORT_CODE.equals(key)) {
            
            String oldWasteSortCode = NdfProductDataConversionUtility.getOldValueString(diff);
            String newWasteSortCode = NdfProductDataConversionUtility.getNewValueString(diff);
            insertModifiedElement(vistaIEN, newWasteSortCode, userValue,WASTE_SORT_CODE_FIELD_NUMBER, oldWasteSortCode);
            
        }  else if (FieldKey.DOT_SHIPPING_NAME.equals(key)) {
            
            String oldDOTShippingName = NdfProductDataConversionUtility.getOldValueString(diff);
            String newDOTShippingName = NdfProductDataConversionUtility.getNewValueString(diff);
            insertModifiedElement(vistaIEN, newDOTShippingName, userValue,DOT_SHIPPING_CODE_FIELD_NUMBER, oldDOTShippingName);
            
        } 
    }    
    

    private void buildProductPackage(ProductPackage productPackage, String userValue, String vistaIen, boolean isAdd, ProductPackage oldProductPackage) {
        String newProductPackageValue = null;
        String oldProductPackageValue = null;
        oldProductPackageValue = NdfProductDataConversionUtility.convertProductPackageValue(oldProductPackage);
        newProductPackageValue = NdfProductDataConversionUtility.convertProductPackageValue(productPackage);
        // Product Package
        if (productPackage != null) {            
            if(isAdd){                
                insertNewChildElement(vistaIen, newProductPackageValue, userValue, PRODUCTPACK_FIELD_NUMBER);                            
            }
            else{                
                insertModifiedElement(vistaIen, newProductPackageValue, userValue, PRODUCTPACK_FIELD_NUMBER, oldProductPackageValue);                
            }
        }
        else{
            if(!isAdd){                
                insertModifiedElement(vistaIen, newProductPackageValue, userValue, PRODUCTPACK_FIELD_NUMBER, oldProductPackageValue);                 
            }
        }

    } 

    private void dosageAutoCreate(PossibleDosagesAutoCreate autoDosage, String userValue, String vistaIen, boolean isAdd, PossibleDosagesAutoCreate oldAutoDosage) {
        String newDosageAutoCreateValue = null;
        String oldDosageAutoCreateValue = null;
        oldDosageAutoCreateValue = NdfProductDataConversionUtility.convertDosageAutoCreate(oldAutoDosage);
        newDosageAutoCreateValue = NdfProductDataConversionUtility.convertDosageAutoCreate(autoDosage);
        if(autoDosage != null){            
            if(isAdd){
                insertNewChildElement(vistaIen, newDosageAutoCreateValue, userValue, POSSIBLEDOSAGE_FIELD_NUMBER);                
            }
            else{
                insertModifiedElement(vistaIen, newDosageAutoCreateValue, userValue, POSSIBLEDOSAGE_FIELD_NUMBER, oldDosageAutoCreateValue);                
            }            
        }
        else{
            if(!isAdd){
                insertModifiedElement(vistaIen, newDosageAutoCreateValue, userValue, POSSIBLEDOSAGE_FIELD_NUMBER, oldDosageAutoCreateValue);                
            }
        }        
    }    
   

    private void fedSchedule(CsFedScheduleVo csFedSchedule, String userValue, String vistaIen, CsFedScheduleVo oldCsFedSchedule,boolean isAdd) {
        String newCsFwdScheduleValue = null;
        String oldCsFwdScheduleValue = null;
        if(!isAdd){ 
            if(csFedSchedule == null){
                newCsFwdScheduleValue = BLANK;                   
            }
            else{
                newCsFwdScheduleValue = NdfProductDataConversionUtility.convertFedSchedule(csFedSchedule.getValue());                 
            }
            if(oldCsFedSchedule == null){
                oldCsFwdScheduleValue = BLANK;                   
            }
            else{
                oldCsFwdScheduleValue = NdfProductDataConversionUtility.convertFedSchedule(oldCsFedSchedule.getValue());                
            }
            insertModifiedElement(vistaIen, newCsFwdScheduleValue, userValue, CSFEDSCH_FIELD_NUMBER, oldCsFwdScheduleValue );                        
        }
        else{
            newCsFwdScheduleValue = NdfProductDataConversionUtility.convertFedSchedule(csFedSchedule.getValue());   
            insertNewChildElement(vistaIen, newCsFwdScheduleValue, userValue, CSFEDSCH_FIELD_NUMBER); 
        }        
              
    }    
    
    
    private String convertPriorInactivationDate(Difference diff){
        
        return diff != null ? MumpsConverter.convertDate((Date)diff.getOldValue()): null;
        
    }
    
    private String convertInactivationDate(Difference diff, ProductVo vaProductVo){
        
        return diff == null ? MumpsConverter.convertDate(vaProductVo.getInactivationDate()) : BLANK;
        
    }

    /**
     * Find the primary drug class. Same logic as {@link ProductVo#getPrimaryDrugClass()}.
     * 
     * @param group drug class group
     * @return primary drug class if found, otherwise an empty drug class
     */
    private static DrugClassVo findPrimaryDrugClass(Collection<DrugClassGroupVo> group) {
        if (group != null) {
            for (DrugClassGroupVo drugClass : group) {
                if (drugClass.getPrimary()) {
                    return drugClass.getDrugClass();
                }
            }
        }

        return new DrugClassVo();
    }

    private void addDifferences(Map<FieldKey, Difference> setDifference) {        

        if (ItemStatus.INACTIVE.equals(AbstractConverter.getOldValue(FieldKey.ITEM_STATUS, setDifference))
            && ItemStatus.ACTIVE.equals(AbstractConverter.getNewValue(FieldKey.ITEM_STATUS, setDifference))) { // reactivate

            setDifference.put(FieldKey.INACTIVATION_DATE, new Difference(FieldKey.INACTIVATION_DATE, new Date(), null));
        }

        if (AbstractConverter.hasNewValue(FieldKey.DRUG_CLASSES, setDifference)) { // check for primary drug class modification
            DrugClassVo newPrimaryClass = findPrimaryDrugClass((Collection<DrugClassGroupVo>) AbstractConverter.getNewValue(
                FieldKey.DRUG_CLASSES, setDifference));

            DrugClassVo oldPrimaryClass = findPrimaryDrugClass((Collection<DrugClassGroupVo>) AbstractConverter.getOldValue(
                FieldKey.DRUG_CLASSES, setDifference));

            if (!newPrimaryClass.equals(oldPrimaryClass)) {                
                setDifference.put(FieldKey.PRIMARY_DRUG_CLASS, new Difference(FieldKey.PRIMARY_DRUG_CLASS, oldPrimaryClass,
                    newPrimaryClass));
            }
        }

    }

    private void insertAddActiveIngredients(Collection<ActiveIngredientVo> ingredients, String vistaIen, String userValue) {
        // Active Ingredients
        if (ingredients != null && ingredients.size() != 0) {

            for (ActiveIngredientVo ai : ingredients) {
                String ingredientIen = NdfProductDataConversionUtility.getStringValue(ai.getIngredient().getNdfIngredientIen());                    
                String VistaIenChild = vistaIen + "," + ingredientIen;

                //making double entry because KIDS build today produces double entries for ingredient header info
                insertNewChildElement(VistaIenChild, ingredientIen, userValue,
                    CHILD_ING_FIELD_NUMBER01);
                insertNewChildElement(VistaIenChild, ingredientIen, userValue,
                    CHILD_ING_FIELD_NUMBER01);
                String strength = NdfProductDataConversionUtility.getStringValue(ai.getStrength());
                insertNewChildElement(VistaIenChild, strength, userValue, CHILD_ING_FIELD_NUMBER1);
                String drugUnit = NdfProductDataConversionUtility.convertDrugUnit(ai.getDrugUnit());
                insertNewChildElement(VistaIenChild, drugUnit, userValue, CHILD_ING_FIELD_NUMBER2);
            }
        }
    }

    private void insertActiveIngredients(Collection<ActiveIngredientVo> ingredients, String vistaIen, String userValue) {
        // Active Ingredients
        if (ingredients != null && ingredients.size() != 0) {

            for (ActiveIngredientVo ai : ingredients) {
                String ingredientIen = NdfProductDataConversionUtility.getStringValue(ai.getIngredient().getNdfIngredientIen());                    
                String VistaIenChild = vistaIen + "," + ingredientIen;

                insertModifiedElement(VistaIenChild, ingredientIen, userValue,
                    CHILD_ING_FIELD_NUMBER01, null);
                String strength = NdfProductDataConversionUtility.getStringValue(ai.getStrength());
                insertModifiedElement(VistaIenChild, strength, userValue, CHILD_ING_FIELD_NUMBER1, null);
                String drugUnit = NdfProductDataConversionUtility.convertDrugUnit(ai.getDrugUnit());
                insertModifiedElement(VistaIenChild, drugUnit, userValue, CHILD_ING_FIELD_NUMBER2, null);
            }
        }
    }

    private void insertRemovedActiveIngredients(Collection<ActiveIngredientVo> ingredients, String vistaIen, String userValue) {
        // Active Ingredients
        if (ingredients != null && ingredients.size() != 0) {
            for (ActiveIngredientVo ai : ingredients) {
                String ingredientIen = NdfProductDataConversionUtility.getStringValue(ai.getIngredient().getNdfIngredientIen());                    
                String VistaIenChild = vistaIen + "," + ingredientIen;

                insertModifiedElement(VistaIenChild, BLANK, userValue, CHILD_ING_FIELD_NUMBER01, null);
                insertModifiedElement(VistaIenChild, BLANK, userValue, CHILD_ING_FIELD_NUMBER1, null);
                insertModifiedElement(VistaIenChild, BLANK, userValue, CHILD_ING_FIELD_NUMBER2, null);
            }
        }
    }

    private void removedActiveIngredients(Difference diff, String vistaIEN, String userValue) {
        Collection<ActiveIngredientVo> oldIngredients = (Collection<ActiveIngredientVo>) diff.getOldValue();
        Collection<ActiveIngredientVo> newIngredients = (Collection<ActiveIngredientVo>) diff.getNewValue();
        Collection<ActiveIngredientVo> removedIngredients = new ArrayList<ActiveIngredientVo>();

        if (oldIngredients != null) {
            if (newIngredients == null) {
                removedIngredients = oldIngredients;
            }
            else {
                for (ActiveIngredientVo oldIngredient : oldIngredients) {

                    boolean removed = true;
                    for (ActiveIngredientVo newIngredient : newIngredients) {

                        if (oldIngredient.getUniqueId().equals(newIngredient.getUniqueId())) {
                            removed = false;
                            break;
                        }
                    }
                    //if removed is TRUE, the object in the previous list was removed
                    if (removed) {
                        removedIngredients.add(oldIngredient);
                    }
                }
                insertRemovedActiveIngredients(removedIngredients, vistaIEN, userValue);
            }
        }
    }

}
