

package gov.va.med.pharmacy.peps.service.common.update.impl;


import java.util.Collection;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;

import gov.va.med.pharmacy.peps.common.vo.FieldKey;
import gov.va.med.pharmacy.peps.common.vo.GenericNameVo;
import gov.va.med.pharmacy.peps.common.vo.ManagedDataVo;
import gov.va.med.pharmacy.peps.common.vo.ManagedItemVo;
import gov.va.med.pharmacy.peps.common.vo.RequestItemStatus;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.common.vo.VuidStatusHistoryVo;
import gov.va.med.pharmacy.peps.common.vo.diff.Difference;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;
import gov.va.med.pharmacy.peps.external.common.preencapsulation.utility.update.item.VaGenericNameConverter;
import gov.va.med.pharmacy.peps.external.common.utility.MumpsConverter;
import gov.va.med.pharmacy.peps.external.common.vo.outbound.common.ItemAction;
import gov.va.med.pharmacy.peps.service.common.update.NdfFileSyncProcessor;


public class VaGenericNameNdfFileSyncProcessor extends AbstractSimpleNdfFileSyncProcessor implements NdfFileSyncProcessor {

    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager
        .getLogger(VaGenericNameNdfFileSyncProcessor.class);
    private static final String MASTERVUID_FIELD_NUMBER = "99.98";
    private static final String VUID_FIELD_NUMBER = "99.99";
    private static final String CHILD_FIELD_NUMBER01 = "99.991,.01";
    private static final String CHILD_FIELD_NUMBER02 = "99.991,.02";
    private static final String FIELD_NUMBER = "1";
    private static final String BLANK = " ";

    public VaGenericNameNdfFileSyncProcessor(Set<FieldKey> fields, String fileNumber, String fieldAddNumber) {
        super(fields, fileNumber, fieldAddNumber);
    }

    @Override
    public void processNew(ManagedDataVo managedData) {
        // TODO Auto-generated method stub

    }

    @Override
    public void processNew(ManagedItemVo managedItem, UserVo user) {

        GenericNameVo vaGenericNameVo = (GenericNameVo) managedItem;

        if (RequestItemStatus.APPROVED.equals(vaGenericNameVo.getRequestItemStatus()) && vaGenericNameVo.getValue() != null) {
            String vistaIen;
            String userValue;
            // IEN
            vistaIen = vaGenericNameVo.getGenericIen();
            userValue = user.getUsername();

            // Name 
            insertNewElement(vistaIen, vaGenericNameVo.getValue(), userValue);
            // Master Entry for VUID
            insertNewChildElement(vistaIen, vaGenericNameVo.getMasterEntryForVuid() ? "1" : "0", userValue,
                MASTERVUID_FIELD_NUMBER);
            // VUID
            insertNewChildElement(vistaIen, StringUtils.isNotBlank(vaGenericNameVo.getVuid()) ? vaGenericNameVo.getVuid()
                                                                                             : BLANK, userValue,
                VUID_FIELD_NUMBER);
            //Effective Date Time
            if (vaGenericNameVo.getEffectiveDates() == null) {
                LOG.error("VA Generic Name Effective Date Cannot be NULL: This is a required Field");
            } else {
                int pairValue = 0;

                for (VuidStatusHistoryVo effectiveDate : vaGenericNameVo.getEffectiveDates()) {
                    pairValue = pairValue + 1;
                    String VistaIenChild = vistaIen + "," + pairValue;

                    insertNewChildElement(VistaIenChild, MumpsConverter.convertDate(effectiveDate.getEffectiveDateTime()), userValue,
                        CHILD_FIELD_NUMBER01);
                    insertNewChildElement(VistaIenChild, effectiveDate.getItemStatus().isActive() ? "1" : "0", userValue,
                        CHILD_FIELD_NUMBER02);
                }

            }

        }

    }

    @Override
    public void processModified(ManagedDataVo managedData) {
        // TODO Auto-generated method stub

    }

    @Override
    public void processModified(ManagedItemVo managedItem, UserVo user, Collection<Difference> differences) {
        
        Map<FieldKey, Difference> setDifference = super.toSetDifference(differences);
        boolean hasDifference =
            VaGenericNameConverter.hasNewOrModifiedFields(super.getFields(), setDifference, ItemAction.MODIFY);

        GenericNameVo vaGenericNameVo = (GenericNameVo) managedItem;        

        if (hasDifference) {            
            if (RequestItemStatus.APPROVED.equals(vaGenericNameVo.getRequestItemStatus()) && vaGenericNameVo.getValue() != null) {                
                EplNdfOutgoingDifferences diffObj = new EplNdfOutgoingDifferences();

                diffObj.setVistaIen(vaGenericNameVo.getGenericIen());
                diffObj.setVistaFieldNumber(FIELD_NUMBER);
                diffObj.setNewValue(vaGenericNameVo.getInactivationDate() != null ? MumpsConverter.convertDate(vaGenericNameVo.getInactivationDate())
                    : BLANK);
                diffObj.setCreatedBy(user.getUsername());                
                processUpdate(diffObj);                
            }

        }

    }
}
