package gov.va.med.pharmacy.peps.service.common.update.impl;

import gov.va.med.pharmacy.peps.common.vo.DispenseUnitVo;
import gov.va.med.pharmacy.peps.common.vo.FieldKey;
import gov.va.med.pharmacy.peps.common.vo.ManagedDataVo;
import gov.va.med.pharmacy.peps.common.vo.ManagedItemVo;
import gov.va.med.pharmacy.peps.common.vo.RequestItemStatus;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.common.vo.diff.Difference;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;
import gov.va.med.pharmacy.peps.external.common.preencapsulation.utility.update.item.VaDispenseUnitConverter;
import gov.va.med.pharmacy.peps.external.common.utility.MumpsConverter;
import gov.va.med.pharmacy.peps.external.common.vo.outbound.common.ItemAction;
import gov.va.med.pharmacy.peps.service.common.update.NdfFileSyncProcessor;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;


/**
 * This class implements methods which populate the new NDF outgoing difference table using the existing vaDispenseUnitSyncRequest object
 * for vista file 50.64 definition and KID build output for adds and modifications of PPS VA dispense unit data.
 * 
 * @author serverbutts
 * @version 1.0
 */
public class VADispenseUnitNdfFileSyncProcessor extends AbstractSimpleNdfFileSyncProcessor implements NdfFileSyncProcessor {
   
    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager.getLogger(VADispenseUnitNdfFileSyncProcessor.class);
        
    private static final String INACTIVATION_FIELD_NUMBER = "1"; 
    public static final Set<FieldKey> FIELDS = Collections.unmodifiableSet(new LinkedHashSet<FieldKey>(Arrays
    .asList(new FieldKey[] { FieldKey.VALUE, FieldKey.INACTIVATION_DATE, FieldKey.ITEM_STATUS })));

        
    public VADispenseUnitNdfFileSyncProcessor(Set<FieldKey> fields, String fileNumber, String fieldAddNumber) {
        super(fields, fileNumber, fieldAddNumber);        
    }
    
    @Override
    public void processNew(ManagedDataVo managedData) {
        
       
    }
    
    @Override
    public void processModified(ManagedDataVo managedData) {
        
     
    }

   
    @Override
    public void processNew(ManagedItemVo managedItem, UserVo user) {
        // Inserts new record into EplNdfOutgoingDifferences table.

        // parse out the data and populate the EplNdfOutgoingDifferences obj for persistence.

        DispenseUnitVo dispenUnitVo = (DispenseUnitVo) managedItem;
        
        if ( (StringUtils.isNotEmpty(dispenUnitVo.getValue())) && (RequestItemStatus.APPROVED.equals(dispenUnitVo.getRequestItemStatus()) )) {

            EplNdfOutgoingDifferences differencesObj = new EplNdfOutgoingDifferences();

            differencesObj.setNewValue(dispenUnitVo.getValue());               

            // need to check what might go in the else clause.
            if(StringUtils.isNotEmpty(dispenUnitVo.getDispenseUnitIen())){
                differencesObj.setVistaIen(dispenUnitVo.getDispenseUnitIen());
            } 
            else{
                LOG.error("Disepnse Unit IEN can't be null.");
            }
            differencesObj.setCreatedBy(user.getUsername());               
            processInsert(differencesObj); 
        }
    }

   
    @Override
    public void processModified(ManagedItemVo managedItem, UserVo user, Collection<Difference> differences) {

        // Inserts either new record or updates older one in the EplNdfOutgoingDifferences table.

        Map<FieldKey, Difference> setDifference = toSetDifference(differences);

        boolean hasDifferences = VaDispenseUnitConverter.hasNewOrModifiedFields(FIELDS, setDifference, ItemAction.MODIFY);
        if (hasDifferences) {                 

            DispenseUnitVo dispenUnitVo = (DispenseUnitVo) managedItem;

            if ((StringUtils.isNotEmpty(dispenUnitVo.getValue())) 
                && (RequestItemStatus.APPROVED.equals(dispenUnitVo.getRequestItemStatus()) )) {
                
                if(VaDispenseUnitConverter.fieldWasModified(FieldKey.ITEM_STATUS, differences)){
                    if(dispenUnitVo.getInactivationDate() != null){
                        insertModifiedElement(dispenUnitVo.getDispenseUnitIen(), MumpsConverter.convertDate(dispenUnitVo.getInactivationDate()),
                           user.getUsername(), INACTIVATION_FIELD_NUMBER, null);
                    }else{
                        insertModifiedElement(dispenUnitVo.getDispenseUnitIen(), " ", user.getUsername(), INACTIVATION_FIELD_NUMBER, null);
                    }
                }
            }
        }
    } 
}
