package gov.va.med.pharmacy.peps.service.common.update.impl;


import java.util.Collection;
import java.util.Map;
import java.util.Set;

import gov.va.med.pharmacy.peps.common.vo.FieldKey;
import gov.va.med.pharmacy.peps.common.vo.ManagedDataVo;
import gov.va.med.pharmacy.peps.common.vo.ManagedItemVo;
import gov.va.med.pharmacy.peps.common.vo.PackageTypeVo;
import gov.va.med.pharmacy.peps.common.vo.RequestItemStatus;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.common.vo.diff.Difference;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;
import gov.va.med.pharmacy.peps.external.common.preencapsulation.utility.update.item.PackageTypeConverter;
import gov.va.med.pharmacy.peps.external.common.utility.MumpsConverter;
import gov.va.med.pharmacy.peps.external.common.vo.outbound.common.ItemAction;
import gov.va.med.pharmacy.peps.service.common.update.NdfFileSyncProcessor;


/**
 * A NdfFileSyncProcessor implementation that handles PackageTypeVo objects.
 * 
 * @author vhaisaduffg
 *
 */
public class PackageTypeNdfFileSyncProcessor extends AbstractSimpleNdfFileSyncProcessor implements NdfFileSyncProcessor {
    
    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager
        .getLogger(PackageTypeNdfFileSyncProcessor.class);
    private static final String FIELD_NUMBER = "1";
    
    public PackageTypeNdfFileSyncProcessor(Set<FieldKey> fields, String fileNumber, String fieldAddNumber) {
        super(fields, fileNumber, fieldAddNumber);        
    }
    

    /**
     * Processes a new PackageTypeVo object.
     * 
     * @param managedData ManagedDataVo
     */
    @Override
    public void processNew(ManagedDataVo managedData) {
        // TODO Auto-generated method stub

    }

    
    @Override
    public void processNew(ManagedItemVo managedItem, UserVo user) {
        PackageTypeVo packageTypeVo = (PackageTypeVo) managedItem;
        
        if (RequestItemStatus.APPROVED.equals(packageTypeVo.getRequestItemStatus()) && packageTypeVo.getValue() != null) {
            EplNdfOutgoingDifferences diffObj = new EplNdfOutgoingDifferences();

            // IEN
            diffObj.setVistaIen(packageTypeVo.getPackagetypeIen());
            diffObj.setNewValue(packageTypeVo.getValue()); 
            diffObj.setCreatedBy(user.getUsername());
            processInsert(diffObj); 
        }
    }

    /**
     * Process a modified PackageTypeVa object.
     * 
     * @param managedData ManagedDataVo
     */
    @Override
    public void processModified(ManagedDataVo managedData) {
        // TODO Auto-generated method stub

    }

    
    @Override
    public void processModified(ManagedItemVo managedItem, UserVo user, Collection<Difference> differences) {
       
     Map<FieldKey, Difference> setDifference =  super.toSetDifference(differences);
     boolean hasDifference = PackageTypeConverter.hasNewOrModifiedFields(super.getFields(), setDifference, ItemAction.MODIFY);

     PackageTypeVo packageTypeVo = (PackageTypeVo) managedItem;

     if (hasDifference) {
         if (RequestItemStatus.APPROVED.equals(packageTypeVo.getRequestItemStatus()) && packageTypeVo.getValue() != null) {
             EplNdfOutgoingDifferences diffObj = new EplNdfOutgoingDifferences();

             diffObj.setVistaIen(packageTypeVo.getPackagetypeIen());
             diffObj.setVistaFieldNumber(FIELD_NUMBER);
             if(packageTypeVo.getInactivationDate() != null){
                 diffObj.setNewValue(MumpsConverter.convertDate(packageTypeVo.getInactivationDate()));                 
             }  
             else{
                 //passing an empty string because this is a non null field
                 diffObj.setNewValue(" ");                  
             }
             diffObj.setCreatedBy(user.getUsername());
             processUpdate(diffObj);
         }

     }

        
    } 
}
