package gov.va.med.pharmacy.peps.service.common.update.impl;

import java.util.Collection;
import java.util.Set;

import gov.va.med.pharmacy.peps.common.utility.PPSConstants;
import gov.va.med.pharmacy.peps.common.vo.NdcVo;
import gov.va.med.pharmacy.peps.common.vo.FieldKey;
import gov.va.med.pharmacy.peps.common.vo.ManagedDataVo;
import gov.va.med.pharmacy.peps.common.vo.ManagedItemVo;
import gov.va.med.pharmacy.peps.common.vo.RequestItemStatus;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.common.vo.diff.Difference;
import gov.va.med.pharmacy.peps.external.common.preencapsulation.utility.update.item.NdcConverter;
import gov.va.med.pharmacy.peps.external.common.utility.MumpsConverter;
import gov.va.med.pharmacy.peps.service.common.update.NdfFileSyncProcessor;

/**
 * This class implements methods which populate the new NDF outgoing difference table for vista file 50.67
 */
public class NdcNdfFileSyncProcessor extends AbstractSimpleNdfFileSyncProcessor implements NdfFileSyncProcessor{
    
    /** FIELDS */

    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager
        .getLogger(NdcNdfFileSyncProcessor.class);
    private static final String NDF_NDC_IEN = ".01";
    private static final String NDC = "1";
    private static final String UPN = "2";
    private static final String MANUFACTURER_IEN= "3";
    private static final String TRADE_NAME = "4";
    private static final String VA_PRODUCT_IEN = "5";
    private static final String INACTIVATION_DATE = "7";
    private static final String PACKAGE_SIZE = "8";
    private static final String PACKAGE_TYPE_IEN = "9";
    private static final String OTX_RX_INDICATOR = "10";
    private static final String ROUTE_OF_ADMINISTRATION = "6,.01";
    
    private String user;
    private String ien;

    NdcConverter ndcConverter;
   
    public NdcNdfFileSyncProcessor(Set<FieldKey> fields, String fileNumber, String fieldAddNumber) {
        super(fields, fileNumber, fieldAddNumber);        
    }
    
    @Override
    public void processNew(ManagedDataVo managedData) {
        // TODO Auto-generated method stub
    }

    @Override
    public void processNew(ManagedItemVo managedItem, UserVo user) {
        
        NdcVo ndcvo = (NdcVo) managedItem;
        
        if (RequestItemStatus.APPROVED.equals(ndcvo.getRequestItemStatus()) && ndcvo.getValue() != null) {
            
            // IEN
            setIen(ndcvo.getNdcIen());
           
            setUser(user.getUsername());
            
            //This field is no longer used default ien to 1 and value of N/A on add.
            insertNewChildElement(getIen()+ ",1","N/A",getUser(),ROUTE_OF_ADMINISTRATION);
                  
            insertNewChildElement(getIen(), ndcvo.getNdcIen(),getUser(),NDF_NDC_IEN);
            
            //vista requires zero to precede the ncd value 
            insertNewChildElement(getIen(), "0" + ndcvo.getNdc().replaceAll("-",""), getUser(),NDC );
            
            if(ndcvo.getUpcUpn() != null)//not provided to vista if null
                insertNewChildElement(getIen(), ndcvo.getUpcUpn(), getUser(),UPN);
            
            insertNewChildElement(getIen(), ndcvo.getManufacturer().getManufacturerIen(),getUser(),MANUFACTURER_IEN);
             
            insertNewChildElement(getIen(), ndcvo.getTradeName(),getUser(),TRADE_NAME);
            
            insertNewChildElement(getIen(), ndcvo.getProduct().getNdfProductIen().toString(),getUser(),VA_PRODUCT_IEN);
            
            insertNewChildElement(getIen(), ndcvo.getPackageSizeVo().getNdfPackageSizeIen(), getUser(),PACKAGE_SIZE);
            
            insertNewChildElement(getIen(), ndcvo.getPackageType().getPackagetypeIen(),getUser(),PACKAGE_TYPE_IEN);
            
            String otxField = " ";
            if (PPSConstants.OVER_THE_COUNTER.equalsIgnoreCase(ndcvo.getOtcRxIndicator().getValue())) { // Over the Counter
                otxField ="O";
            } else if (PPSConstants.PRESCRIPTION.equalsIgnoreCase(ndcvo.getOtcRxIndicator().getValue())) { // Prescription
                otxField = "R";
            }

            insertNewChildElement(getIen(), otxField, getUser(),OTX_RX_INDICATOR);
        }
    }
     
    @Override
    public void processModified(ManagedDataVo managedData) {
        // TODO Auto-generated method stub
        
    }

    @Override
    public void processModified(ManagedItemVo managedItem, UserVo user, Collection<Difference> differences) {
       NdcVo ndcvo = (NdcVo) managedItem;
        
        if (RequestItemStatus.APPROVED.equals(ndcvo.getRequestItemStatus()) && ndcvo.getValue() != null) {
            
            // IEN
            setIen(ndcvo.getNdcIen());
                        
            setUser(user.getUsername());
            
            if(NdcConverter.fieldWasModified(FieldKey.UPC_UPN, differences)){
                if(ndcvo.getUpcUpn() != null){ 
                    insertModifiedElement(getIen(), ndcvo.getUpcUpn(), getUser(),UPN, null);
                }else{
                    insertModifiedElement(getIen(), " ", getUser(),UPN, null);
                }
            }
            
            if(ndcvo.getManufacturer() != null
                && NdcConverter.fieldWasModified(FieldKey.MANUFACTURER, differences)){
                insertModifiedElement(getIen(),ndcvo.getManufacturer().getManufacturerIen(),getUser(),MANUFACTURER_IEN, null);
            } 
            
            if(ndcvo.getTradeName() != null && NdcConverter.fieldWasModified(FieldKey.TRADE_NAME, differences)){
                insertModifiedElement(getIen(), ndcvo.getTradeName(), getUser(),TRADE_NAME,null);
            }
            
            if(ndcvo.getProduct() != null
                && NdcConverter.fieldWasModified(FieldKey.PRODUCT, differences)){
                insertModifiedElement(getIen(),ndcvo.getProduct().getNdfProductIen().toString(), getUser(), VA_PRODUCT_IEN,null);
            }
            
            if(NdcConverter.fieldWasModified(FieldKey.ITEM_STATUS, differences)){
                if(ndcvo.getInactivationDate() != null){
                    insertModifiedElement(getIen(),MumpsConverter.convertDate(ndcvo.getInactivationDate()), getUser(),INACTIVATION_DATE,null);
                }else{
                    //TODO test reactivate
                    insertModifiedElement(getIen()," ", getUser(),INACTIVATION_DATE,null);
                }
            }
            
            if(ndcvo.getPackageSize() != null
                && NdcConverter.fieldWasModified(FieldKey.PACKAGE_SIZE, differences)){
                insertModifiedElement(getIen(),ndcvo.getPackageSizeVo().getNdfPackageSizeIen(), getUser(),PACKAGE_SIZE, null);
            }
            
            if(ndcvo.getPackageType() != null 
                && NdcConverter.fieldWasModified(FieldKey.PACKAGE_TYPE, differences)){
                insertModifiedElement(getIen(),ndcvo.getPackageType().getPackagetypeIen(),getUser(),PACKAGE_TYPE_IEN,null);
            }
            
            if(ndcvo.getOtcRxIndicator() !=null 
                && NdcConverter.fieldWasModified(FieldKey.OTC_RX_INDICATOR, differences)){
                String otxField = " ";
                if (PPSConstants.OVER_THE_COUNTER.equalsIgnoreCase(ndcvo.getOtcRxIndicator().getValue())) { // Over the Counter
                    otxField ="O";
                } else if (PPSConstants.PRESCRIPTION.equalsIgnoreCase(ndcvo.getOtcRxIndicator().getValue())) { // Prescription
                    otxField = "R";
                }
                insertModifiedElement(getIen(),otxField, getUser(),OTX_RX_INDICATOR,null);
            }   
        }
    }
    
    /**
     * @return the user
     */
    public String getUser() {
        return user;
    }

    /**
     * @param user the user to set
     */
    public void setUser(String user) {
        this.user = user;
    }
    
    /**
     * @return the ien
     */
    public String getIen() {
        return ien;
    }
    
    /**
     * @param ien the ien to set
     */
    public void setIen(String ien) {
        this.ien = ien;
    }
}   
    
    
    
    
    
    
    