package gov.va.med.pharmacy.peps.service.common.update.impl;



import java.util.Collection;
import java.util.Map;
import java.util.Set;

import gov.va.med.pharmacy.peps.common.vo.FieldKey;
import gov.va.med.pharmacy.peps.common.vo.ManagedDataVo;
import gov.va.med.pharmacy.peps.common.vo.ManagedItemVo;
import gov.va.med.pharmacy.peps.common.vo.ManufacturerVo;
import gov.va.med.pharmacy.peps.common.vo.RequestItemStatus;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.common.vo.diff.Difference;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;
import gov.va.med.pharmacy.peps.external.common.preencapsulation.utility.update.item.ManufacturerConverter;
import gov.va.med.pharmacy.peps.external.common.utility.MumpsConverter;
import gov.va.med.pharmacy.peps.external.common.vo.outbound.common.ItemAction;
import gov.va.med.pharmacy.peps.service.common.update.NdfFileSyncProcessor;


public class ManufacturerNdfFileSyncProcessor extends AbstractSimpleNdfFileSyncProcessor implements NdfFileSyncProcessor {
    
    
    private static final org.apache.logging.log4j.Logger LOG = org.apache.logging.log4j.LogManager
        .getLogger(ManufacturerNdfFileSyncProcessor.class);    
    private static final String INACTIVATION_FIELD_NUMBER = "2"; 
    private static final String BLANK = " ";
    
    public ManufacturerNdfFileSyncProcessor(Set<FieldKey> fields, String fileNumber, String fieldAddNumber) {
        super(fields, fileNumber, fieldAddNumber);        
    }

    @Override
    public void processNew(ManagedDataVo managedData) {
        // TODO Auto-generated method stub

    }
    

    @Override
    public void processNew(ManagedItemVo managedItem, UserVo user) {

        ManufacturerVo manufacturerVo = (ManufacturerVo) managedItem; 
        
        if (RequestItemStatus.APPROVED.equals(manufacturerVo.getRequestItemStatus()) && manufacturerVo.getValue() != null) {
            EplNdfOutgoingDifferences diffObj = new EplNdfOutgoingDifferences();

            diffObj.setVistaIen(manufacturerVo.getManufacturerIen());
            diffObj.setNewValue(manufacturerVo.getValue());  
            diffObj.setCreatedBy(user.getUsername());            
            processInsert(diffObj);             
        }

    }

    @Override
    public void processModified(ManagedDataVo managedData) {
        // TODO Auto-generated method stub

    }

    @Override
    public void processModified(ManagedItemVo managedItem, UserVo user, Collection<Difference> differences) {

        Map<FieldKey, Difference> setDifference = super.toSetDifference(differences);
        boolean hasDifference = ManufacturerConverter.hasNewOrModifiedFields(super.getFields(), setDifference, ItemAction.MODIFY);

        ManufacturerVo manufacturerVo = (ManufacturerVo) managedItem;

        if (hasDifference) {
            if (RequestItemStatus.APPROVED.equals(manufacturerVo.getRequestItemStatus()) && manufacturerVo.getValue() != null) {
                EplNdfOutgoingDifferences diffObj = new EplNdfOutgoingDifferences();

                diffObj.setVistaIen(manufacturerVo.getManufacturerIen());               
                diffObj.setVistaFieldNumber(INACTIVATION_FIELD_NUMBER);                
                diffObj.setNewValue(manufacturerVo.getInactivationDate() != null ? MumpsConverter.convertDate(manufacturerVo.getInactivationDate())
                               : BLANK);
                diffObj.setCreatedBy(user.getUsername());                
                processUpdate(diffObj); 
            }
        }

    }
   
    
}
