

package gov.va.med.pharmacy.peps.service.common.update.impl;


import gov.va.med.pharmacy.peps.common.vo.DrugUnitVo;
import gov.va.med.pharmacy.peps.common.vo.FieldKey;
import gov.va.med.pharmacy.peps.common.vo.ManagedDataVo;
import gov.va.med.pharmacy.peps.common.vo.ManagedItemVo;
import gov.va.med.pharmacy.peps.common.vo.RequestItemStatus;
import gov.va.med.pharmacy.peps.common.vo.UserVo;
import gov.va.med.pharmacy.peps.common.vo.diff.Difference;
import gov.va.med.pharmacy.peps.domain.common.model.EplNdfOutgoingDifferences;
import gov.va.med.pharmacy.peps.external.common.preencapsulation.utility.update.item.PackageTypeConverter;
import gov.va.med.pharmacy.peps.external.common.utility.MumpsConverter;
import gov.va.med.pharmacy.peps.external.common.vo.outbound.common.ItemAction;
import gov.va.med.pharmacy.peps.service.common.update.NdfFileSyncProcessor;

import java.util.Collection;
import java.util.Map;
import java.util.Set;


public class DrugUnitNdfFileSyncProcessor extends AbstractSimpleNdfFileSyncProcessor implements NdfFileSyncProcessor {

    private static final String INACTIVATION_FIELD_NUMBER = "1";
    private static final String BLANK = " ";

    public DrugUnitNdfFileSyncProcessor(Set<FieldKey> fields, String fileNumber, String fieldAddNumber) {
        super(fields, fileNumber, fieldAddNumber);
        // TODO Auto-generated constructor stub
    }

    @Override
    public void processNew(ManagedDataVo managedData) {
        // TODO Auto-generated method stub

    }

    @Override
    public void processNew(ManagedItemVo managedItem, UserVo user) {
        DrugUnitVo drugUnitVo = (DrugUnitVo) managedItem;
        if (RequestItemStatus.APPROVED.equals(drugUnitVo.getRequestItemStatus()) && drugUnitVo.getValue() != null) {
            EplNdfOutgoingDifferences differences = new EplNdfOutgoingDifferences();

            differences.setVistaIen(drugUnitVo.getDrugUnitIen());
            differences.setNewValue(drugUnitVo.getValue());
            differences.setCreatedBy(user.getUsername());
            processInsert(differences);
        }

    }

    @Override
    public void processModified(ManagedDataVo managedData) {
        // TODO Auto-generated method stub

    }

    /** 
     * </pre>
     *   "TEMP","DATANT",50.607,1) ----add
     *    990^3140318.154004^.01^360^A
     *    "TEMP","DATANT",50.607,2)
     *    RJC
     *    "TEMP","DATAO",50.607,1) ----inactivate
     *    10^3140318.151633^1^360^
     *    "TEMP","DATAO",50.607,2)
     *    3140625
     *    "TEMP","DATAO",50.607,1) ----reactivate
     *    102^3140318.151633^1^360^
     *    "TEMP","DATAO",50.607,2)
     *
     *    </pre>
     * */
    @Override
    public void processModified(ManagedItemVo managedItem, UserVo user, Collection<Difference> differences) {
        Map<FieldKey, Difference> setDifference = super.toSetDifference(differences);
        boolean hasDifference =
            PackageTypeConverter.hasNewOrModifiedFields(super.getFields(), setDifference, ItemAction.MODIFY);

        DrugUnitVo drugUnitVo = (DrugUnitVo) managedItem;

        if (hasDifference) {
            if (RequestItemStatus.APPROVED.equals(drugUnitVo.getRequestItemStatus()) && drugUnitVo.getValue() != null) {
                EplNdfOutgoingDifferences diffObj = new EplNdfOutgoingDifferences();

                diffObj.setVistaIen(drugUnitVo.getDrugUnitIen());                
                diffObj.setVistaFieldNumber(INACTIVATION_FIELD_NUMBER);
                diffObj.setNewValue(drugUnitVo.getInactivationDate() != null ? MumpsConverter.convertDate(drugUnitVo.getInactivationDate())
                            : BLANK);
                diffObj.setCreatedBy(user.getUsername());
                processUpdate(diffObj);

            }

        }
    }
}
